const fs = require('fs');
const path = require('path');

module.exports = {
  publicPath: './',
  configureWebpack: {
    resolve: {
      alias: {
        '$$': '@sxf/jquery',
        'jquery$': '@sxf/jquery',
        'vue$': 'vue/dist/vue.js',
        'vtComponent$': '@sxf/vt-component',
        'WindowCreator$': '@sxf/vt-component/dist/static/js/vueWindowCreator'
      }
    }
  },
  devServer: {
    before(app) {
      app.use((req, res, next) => {
        let matchMod = req.headers.referer && req.headers.referer.match(/\?mock=([a-z]+)/);

        // 不加mock参数或者mock=local则读取本地文件，否则读取后台数据
        if (matchMod && matchMod[1] !== 'local') {
          next();
          return;
        }

        let url = `./vapi/${req.path.replace(/^\/?/, '')}`,
            isEnd = false;

        try {
          let file = fs.statSync(url);

          if (file.isFile()) {
            if (path.basename(url).indexOf('\.') === -1) {
              res.json(JSON.parse(
                fs.readFileSync(url)
              ));
            }

            isEnd = true;
          }
        } catch (error) {

          // do nothing
        }

        if (!isEnd) {
          next();
        }
      });
    },
    proxy: {
      '/': {
        target: 'http://127.0.0.1:8000'
      }
    }
  }
};
