// Modules to control application life and create native browser window
const { app, ipcMain, BrowserWindow, globalShortcut, shell } = require('electron');
const path = require('path');
const http = require('http');



// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let protocol = 'http';
let host = '127.0.0.1';
let port = 8000;
let url = protocol + '://' + host + ':' + port;
let intervalTask = '';
let totalCount = 1;
let fakeWindow;
let mainWindow;
let handleWindow;

function createWindow () {
    let options = {
        width: 1019,
        height: 665,
        resizable: false, // 禁止双击最大化和拖动改变大小
        frame: false, // 隐藏边框
        show: false, // 首屏渲染完成再显示
        titleBarStyle: 'hiden', // 隐藏mac标题
        webPreferences: {
            webSecurity: false,
            preload: path.join(__dirname, 'preload.js')
        }
    };

    // Create the browser window.
    mainWindow = new BrowserWindow(options);
    fakeWindow = new BrowserWindow(options);

    fakeWindow.loadFile('./loading.html');

    fakeWindow.once('ready-to-show', function () {
        fakeWindow.show();
    });

    intervalTask = setInterval(function () {
        checkServerStatus(function (data) {

            let MAX_ERROR_TIMES = 60;
            if (!data) {
                totalCount++;
                if (totalCount >= MAX_ERROR_TIMES) {
                    app.quit();
                }
                return;
            }
            clearInterval(intervalTask);
            mainWindow.loadURL(url + `/view/static/resources/app/dist/index.html?language=${data.language}&upid=${data.upid}`);
        });
    }, 1000);

    mainWindow.once('ready-to-show', function () {
      mainWindow.show();
      fakeWindow.close();
    });

    // Emitted when the window is closed.
    mainWindow.on('closed', function () {
        // Dereference the window object, usually you would store windows
        // in an array if your app supports multi windows, this is the time
        // when you should delete the corresponding element.
        mainWindow = null;
    });

    fakeWindow.on('closed', function () {
        fakeWindow = null;
    });
}

function checkServerStatus (callback) {
    let req = http.request({
        hostname: host,
        port: port,
        path: '/atools/infos/infos',
        method: 'GET',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        }
    }, function (res) {
        res.setEncoding('utf8');
        res.on('data', function (data) {
            let json = {};
            try {
                json = JSON.parse(data).data;
            } catch(e) {
                // do nothing
            }
            callback(json);
        });
    });
    req.on('error', function () {
        callback(false);
    });
    req.end();
}

app.commandLine.appendSwitch('ignore-certificate-errors');
app.commandLine.appendSwitch('disable-http-cache');

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', function () {
    createWindow();

    // Open the DevTools.
    globalShortcut.register('ctrl+shift+alt+S+F', function () {
        mainWindow.webContents.openDevTools();
    });

    // disable refresh function
    globalShortcut.register('ctrl+shift+R', function () {});
});

// Quit when all windows are closed.
app.on('window-all-closed', function () {
    // On macOS it is common for applications and their menu bar
    // to stay active until the user quits explicitly with Cmd + Q
    if (process.platform !== 'darwin') {
        globalShortcut.unregisterAll();
        let req = http.request({
            hostname: host,
            port: port,
            path: '/manager/progress/stop',
            method: 'POST'
        });
        req.on('error', function () {
            app.quit();
        });
        req.end();
    }
});

app.on('activate', function () {
    // On macOS it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (mainWindow === null) createWindow();
});

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.

ipcMain.on('app-close', (event, isSubWindow) => {

    // 手动关闭主进程，需要把次进程也关掉
    if (!isSubWindow) {
        mainWindow && mainWindow.close();
    }

    handleWindow && handleWindow.close && handleWindow.close();
});

ipcMain.on('app-min', (event, isSubWindow) => {
    if (isSubWindow) {
        handleWindow && handleWindow.minimize && handleWindow.minimize();
        return;
    }
    mainWindow && mainWindow.minimize && mainWindow.minimize();
});

// 使用系统默认浏览器打开链接
ipcMain.on('open-url', (event, url) => {
    shell.openExternal(url);
});

// 在业务代码中调用创建次窗口的函数
ipcMain.on('open-secondary-window', (event, data) => {

    // 检查 handleWindow 是否存在且未被关闭
    if (!handleWindow || handleWindow.isDestroyed()) {
        handleWindow = new BrowserWindow({
            width: 1019,
            height: 665,
            resizable: false,
            frame: false,
            show: false,
            titleBarStyle: 'hidden',
            webPreferences: {
                webSecurity: false,
                preload: path.join(__dirname, 'preload.js')
            }
        });

        handleWindow.loadURL(url + `/view/static/resources/app/handle_window_dist/index.html?data=${JSON.stringify(data)}`);

        handleWindow.on('closed', function () {
            handleWindow = null;
        });
    }

    handleWindow.show();
});