#!/bin/bash
# UEFI x86 环境

# [新增]命名方式修改,避免fake RAID冲突
# [新增]逻辑盘预留1G的空间
# [新增]逻辑盘大小<128G报错
# [新增]执行情况写入日志并打印
# [新增]盘符外部传入 $1 $2
# [新增]封装成函数，方便调用
# 2024/09/12 更新如下
# 预留空间从1G -> 12M

main()
{
    declare -a install_dev_disk_list
    # 存放执行日志
    CLOG_PATH="./install.log"
    soft_raid_system_name="hci_system_disk"
    install_dev_disk_list[0]=$1
    install_dev_disk_list[1]=$2
    SIZE_DISK1=$(blockdev --getsize64 ${install_dev_disk_list[0]})
    SIZE_DISK2=$(blockdev --getsize64 ${install_dev_disk_list[1]})
    MIN_SIZE=$(($SIZE_DISK1<$SIZE_DISK2?$SIZE_DISK1:$SIZE_DISK2))
    # 母盘刻录大小必须小于还原物理盘12MiB
    #SIZE_TO_USE=$((240 - 16 * 1024 * 1024)) # 预留12MiB的空间 
    SIZE_TO_USE=$(($MIN_SIZE - 12 * 1024 * 1024)) # 预留12MiB的空间 
    SIZE_TO_USE_KB=$(($SIZE_TO_USE / 1024)) # 将字节转换为千字节
    MIN_SIZE_KB=$((128 * 1024 * 1024))
    if [[ $SIZE_TO_USE_KB -lt $MIN_SIZE_KB ]]; then
        echo "Error: The size to use for the RAID array is less than 128GiB." | tee -a ${CLOG_PATH}
        exit 1
    fi
    mdadm --create /dev/md/${soft_raid_system_name} \
          --level=1 \
          --raid-devices=2 \
          ${install_dev_disk_list[0]} \
          ${install_dev_disk_list[1]} \
           --metadata=0.90 \
          --bitmap=internal  \
          --size=${SIZE_TO_USE_KB} \
          --run >>${CLOG_PATH} 2>&1
    result=$?
    if [[ ${result} -ne 0 ]]; then
        echo "Failed to create RAID array, exit code: ${result}" | tee -a ${CLOG_PATH}
        exit ${result}
    else
        echo "success to exec pre.sh" | tee -a ${CLOG_PATH}
    fi
}
main "$@"