# 功能说明
解析UKEY/VKEY序列号文件，返回序列号的key ID，fingerprint以及云平台操作系统的授权信息.

# 用法说明
`./lic_parse -file <file_path>`

其中，
`file_path`: 许可证文件路径

输出为json string，json格式为
```json
{
  "key_id": "<string>", // key ID
  "fingerprint": "<string>", // 指纹
  "auth_info": "<json> 或 <json string>" // aCPOS/aCPOS-ARM授权信息
}
```

其中当license为UKey时，`auth_info`以json string返回，json格式为
```json
{
  "aCPOS": {
    "check_result": 0, // 序列号检查结果（0表示正常，非0表示异常）
    "analyze_info": {
      "universal_hosts_num": 3, // 通用版物理主机数
      "kylin_hosts_num": 3, // 麒麟版物理主机数
      "username": "<username>", // username
      "keyid": "<keyid>" // key ID
    }
  },
  "aCPOS-ARM": {
    // 同aCPOS
  }
}
```

> 注意：若程序正常结束，则返回状态码0，且结果输出到标准输出；
若程序异常结束，则返回非0状态码，且结果输出到标准错误。


# 使用示例
## 示例一：UKey
`./lic_parse -file /sf/ukey.lic`

```json
{
  "key_id": "FEFCFE27053B0000",
  "fingerprint": "",
  "auth_info": "{\"aCPOS\":{\"check_result\":0,\"analyze_info\":{\"universal_hosts_num\":\"80\",\"kylin_hosts_num\":\"40\",\"username\":\"何伟61225-hw\",\"keyid\":\"FEFCFE27053B0000\",\"aCPOS-ARM\":{\"check_result\":0,\"analyze_info\":{\"universal_hosts_num\":\"70\",\"kylin_hosts_num\":\"50\",\"username\":\"何伟61225-hw\",\"keyid\":\"FEFCFE27053B0000\"}}}"
}
```

## 示例二：VKey
`./lic_parse -file /sf/vkey.lic`

```json
{
  "key_id": "",
  "fingerprint": "AQM0BIoDAQAEAWKJrwJ4Gz5XVaerQTadI/DSqOCMVT2z0YF/XWMWkFyNJJ7w1hkA4yHDflPmZDDsy8w5mxXD9Je4qDIGv1/C9U3RAmuQKGG7Q2Xu0VVor9EdSDBsXnt4QZbreSnssWzKrc5KuxN9SL0GeJLzM+QNDHUWIig2BL2I+s/4OGRedqf0ZPVsigAAcQKKAiJ6LEvYj3Q1VFiQplidQL4DBW6x/G6OXcspkFPe2NoBzemwZX+2i0h26nHmGvq8qaxLwHEvjZ3Z56VV5GiGzt7kDvv75u8Ttaqt0n9RTWFnymLgmz4cepMbsxUR4uExxRbSzM990lGt+q685M92y/S/kZ/hWh8CABQAMKmw12ixU0nry5A7GHczXAMAFgOcAgABgIo3NyUXlfxgmUR289Ph/6HeZuT2qHzzKAgSsl7CbOKPdn6m06HcStXibc/sbjhPnMEEz3vRMKzjKFAxDyOjR9ncF2EimQaLZ67Dnti98XSAUCUBLyXdVPf5KiFLPquJggzSOL1aRzYFCb/lYyBHsE1sDdop+A3vhQd8CJVTOFWYFuPGdG2+EkgGTCzZKgR6HPdXXsnJx23VhLDXVmxWpPzVIHe+iprl0fXIMl1W1fFbdfGR77YsAQOpWGV5jfHOosEoSXlnxZ1P4y0gff+SQkrmnFK8UFw+MHg0A/0sImEHMk5n0PhiuJGKz50RtkEhpGEPIq8su3rPg6PT/HAv5bEVHBK07prCLAgTLCIcmtD0NRsgfxiK0qOBlJHVvRqXCdLBFjXcc0pDtWR1uJ95YPUrQvTqSvESXEmy1quyCa9nrpL6ImnvdL1ym+Y2NWLsIDiPrliDMWBUKiTc/IKzud2afnVfeqYcH9g/sXX+Jh3p/gx2rp9Qqoe2tJ6vgxvsIJcD8I4Wi+N71dUY+GwCmIWNTl84/U0P/q1Wykbw6C0XeK5ePxyqlHeG7Hzh6aqDkcXnTjDb9dmEGbWfDRjUPiqfrKWtSugFNuGdwoUb7VLYSu6Xk4A0POP/x9mkZpDQk+p+9OuybigmI4+9cTNI+JMeBBWfWDTk4KlLSeB+D34ax+b+7Jlq7O2c/xc9QozFby9WzJVYSeZaHj+G2VBg9RKkN0/+ni0HqG34+08LidxxcZzxkce6JMz2hNS/nZjw9sBIxRaGjSwd2gEP7vvVES5kNTPahjKMtu76YYR8KPGmMNi2D67WafxLumQ61ZOc4IyTe0Eo8M02yjwq8fKA7i7ES9W7cfs5Lymghhurvd66zP1VpSTdgCt8FZ1Da1/ujgWPDggjszlT5LdQtgdnr2fEb853V8Y/KELIK5VrehAjN2svyGy/DA7SsOqByUa4JeG8++WBeOcJPghKK4ohamduomP9+eJGkUwCVsRNNYpKmLDBscJiBFdd/URBk1jIwQe8+eOJzfaDOZ0V0KY=",
  "auth_info": {
    "aCPOS": {
      "kylin_hosts_num": "{\"key\":\"kylin_hosts_num\",\"name\":\"麒麟版物理主机数\",\"type\":2,\"value\":\"120\"}",
      "universal_hosts_num": "{\"key\":\"universal_hosts_num\",\"name\":\"通用版物理主机数\",\"type\":2,\"value\":\"0\"}"
    },
    "aCPOS-ARM": {
      "kylin_hosts_num": "{\"key\":\"kylin_hosts_num\",\"name\":\"麒麟版物理主机数\",\"type\":2,\"value\":\"60\"}",
      "universal_hosts_num": "{\"key\":\"universal_hosts_num\",\"name\":\"通用版物理主机数\",\"type\":2,\"value\":\"60\"}"
    }
  }
}
```
