#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

import os
import sys
import signal
import logging
import traceback

reload(sys)
sys.setdefaultencoding('utf8')

import fire
import pylib.utils.utiltools as common
# from modules.tier import tier
# from modules.disk import disk
# from modules.badsector import badsector
# from modules.shard import shard
# from modules.splitbrain import splitbrain
# from modules.network import network
# from modules.datarecover import datarecover
# from modules.rebalance import rebalance
from modules.bad_blocks import bad_blocks_export
from modules.dir_recovery import dir_recovery_export
from modules.file_recovery import file_recovery_export
from modules.resource_clean import resource_clean_export


def _version():
    print("vsfire v1.0")
    return

def vsfire_signal_handler(sig, frame):
    common.logger.warn('Got signal: {}, frame: {}'.format(sig, frame))
    lock_file = common.vsfire_concurrency_lock_file
    if not os.path.exists(lock_file):
        return
    with common.VsfireConcurrencyFlock(lock_file, max_concurrency) as concurrency_lock:
        pass

if __name__ == '__main__':
    module = {
        "version": _version,
        # "tier": tier,
        # "disk": disk,
        # "badsector": badsector,
        # "shard": shard,
        # "splitbrain": splitbrain,
        # "network": network,
        # "datarecover": datarecover,
        # "rebalance": rebalance,
        "bad_blocks": bad_blocks_export,
        "dir_recovery": dir_recovery_export,
        "file_recovery": file_recovery_export,
        "resource_clean": resource_clean_export
    }
    vsfire_config_file = os.path.join(common.VSFIRE_WORK_DIR, 'config', 'vsfire.conf')
    max_concurrency = common.VsfireConfig(vsfire_config_file).get_int('common', 'max_concurrency')
    if max_concurrency <= 0 or max_concurrency > common.max_concurrency:
        print 'failed to supported, config max_concurrency: {} is invalid'.format(max_concurrency)
        print common.Colored().red('解析配制文件失败，异常退出')
    else:
        has_logger = False
        try:
            lock_file = common.vsfire_concurrency_lock_file
            if not os.path.exists(lock_file):
                os.mknod(lock_file)

            signal.signal(signal.SIGHUP, vsfire_signal_handler)  # 挂断信号
            signal.signal(signal.SIGTERM, vsfire_signal_handler)  # 一般终止信号
            with common.VsfireConcurrencyFlock(lock_file, max_concurrency) as concurrency_lock:
                sequence_id = concurrency_lock.get_sequence()
                vsfire_log_filename = os.path.join(common.VSFIRE_WORK_DIR, 'log', 'vsfire_{}.log'.format(sequence_id))
                logging.basicConfig(filename=vsfire_log_filename, level=logging.INFO,
                                    format='[%(asctime)s] [%(levelname)s] [%(filename)s:%(lineno)s:%(funcName)s] '
                                           '%(message)s')
                has_logger = True
                print common.Colored().cyan('日志打印路径：{}'.format(vsfire_log_filename))
                fire.Fire(module)
        except:
            traceback_msg = traceback.format_exc()
            if has_logger:
                common.logger.error('Got except: {}'.format(traceback_msg))
            else:
                print 'Got except: {}'.format(traceback_msg)
            if 'raise FireExit' not in traceback_msg:  # 查询帮助退出不打印错误
                if 'Manual check cancellation' in traceback_msg:
                    print common.Colored().red('执行失败，手动取消退出')
                elif 'too many vsfire are running' in traceback_msg:
                    print common.Colored().red('执行失败，太多vsfire工具正在运行，请稍后再重试')
                else:
                    print common.Colored().red('执行失败，异常退出')
