#!/sf/vs/bin/python
# -*- coding: utf-8 -*-
import re
import os
import sys
import json
import argparse
import traceback

reload(sys)
sys.setdefaultencoding('utf8')

TOOL_WORK_DIR = os.path.dirname(__file__)
VSFIRE_WORK_DIR = '{}/{}'.format(TOOL_WORK_DIR, '../..')
VSFIRE_WORK_DIR = os.path.abspath(VSFIRE_WORK_DIR)
sys.path.append(VSFIRE_WORK_DIR)
import pylib.utils.utiltools as common

# 管理面定义的前置检查错误信息路径
VS_PRECHECK_ERROR_CONFIG = '/tmp/vs/vs_check_mgr_result.json'
VSTS_FIX_TOOL_PATH = '/sf/vs/lib/python-srv/vs_upgrade_precheck/scripts/vsts_fix_tools.py'
VSTS_FIX_DUPNAME_PATH = '/sf/vs/lib/python-srv/vs_upgrade_precheck/scripts/vs_fix_dupname_file.js'

# 文件副本状态异常错误码
BAD_FILE_ERRNO = '0xA0704DD8'
# 文件同名不同GFID错误码
DUPGFID_FILE_ERRNO = '0xa0704dca'
# 目录副本状态异常错误码
BAD_DIR_ERRNO = '0xA0704DD9'
# 文件大小不对齐错误码
MISALIGNED_FILE_ERRNO = '0xA0704804'
# 分层内文件残留错误码
# TIER_RESIDUE_FILE_ERRNO = '0xA0704FBF'
TIER_RESIDUE_FILE_ERRNO = '0xa0704ff4'


def fix_bad_file(volname, filename):
    if not volname or not filename:
        return
    # 只对特殊文件，T文件进行处理
    cmdline = '{} {} {}'.format(VSTS_FIX_DUPNAME_PATH, volname, filename)
    print cmdline
    # common.cli(cmdline, False)


def fix_dupgfid_file(volname, filename):
    if not volname or not filename:
        return
    # 只对特殊文件，T文件进行处理
    cmdline = '{} {} {}'.format(VSTS_FIX_DUPNAME_PATH, volname, filename)
    print cmdline
    # common.cli(cmdline, False)


def fix_bad_dir(dirname):
    if not dirname:
        return
    cmdline = '{} dir_recovery dir_recovery {}'.format(os.path.join(VSFIRE_WORK_DIR, 'vsfire.py'), dirname)
    print cmdline
    # common.cli(cmdline, False)


# lvname: oQPuN9-235q-Vvqb-jJX6-40Zi-h2fp-sDNEiy_e8f42dbeb9404a90ba2bed6cad18f0cd.0
def fix_misaligned_file(volname, lvname):
    if not volname or not lvname:
        return
    cmdline = '/sf/vs/bin/vs_lv2file.sh {} | grep {}'.format(lvname, volname)
    result = common.cli(cmdline, False)
    if result:
        nfs_path = '/sf/data/vs/gfs/{}'.format(volname)
        filename = result.replace(nfs_path, '').strip()
        cmdline = '{} file_recovery copy_and_replace {}'.format(os.path.join(VSFIRE_WORK_DIR, 'vsfire.py'), filename)
        print cmdline
        # common.cli(cmdline, False)


def fix_tcache_residual_file(brick_path, gfid):
    if not brick_path or not gfid:
        return

    cmdline = '{} resource_clean tier_file_clean {} {}'.\
        format(os.path.join(VSFIRE_WORK_DIR, 'vsfire.py'), brick_path, gfid)
    print cmdline
    # common.cli(cmdline, False)


def get_result_data(item_object):
    if item_object and item_object.get('res') and item_object['res'].get('data'):
        if item_object['res']['data'].get('result_file'):
            result_file = item_object['res']['data']['result_file']
            if os.path.exists(result_file):
                with open(result_file, 'r') as result_f:
                    return json.load(result_f)
        else:
            return item_object['res']['data']
    return None


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--path', '-p',
                        default='/tmp/vs/vs_check_mgr_result.json',
                        help='指定需要读取VDI升级异常的输出文件')
    args = parser.parse_args()
    if not isinstance(args.path, str) or not args.path.startswith('/') or not os.path.exists(args.path):
        print '指定的VDI升级异常输出文件路径不合法或不存在: {}'.format(args.path)
        return -1

    try:
        version = common.get_vs_version()
        # 当前只支持vs2.8版本
        if not common.is_vs_version_valid(version) and version != common.VS_VERSION_2_8:
            print '当前环境版本号不合法: {}'.format(version)
            return -1

        volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
        if not volume_name:
            print '当前环境获取卷异常: {}'.format(volume_name)
            return -1

        vs_precheck_errno_config = args.path
        with open(vs_precheck_errno_config, 'r') as f:
            json_data = json.load(f)
            check_res = json_data.get('check_res')
            if not check_res:
                print '指定的VDI升级异常输出文件内容不合法: {}'.format(vs_precheck_errno_config)
                return -1
            glusterfs = check_res.get('Glusterfs')
            if not glusterfs:
                print '指定的VDI升级异常输出文件内容不合法: {}'.format(vs_precheck_errno_config)
                return -1

            # 处理脑裂
            check_gfid_conflict = glusterfs.get('check_gfid_conflict')
            result_data = get_result_data(check_gfid_conflict)

            # 脑裂文件处理
            if result_data.get(BAD_FILE_ERRNO.lower()):
                for bad_files in result_data.get(BAD_FILE_ERRNO.lower()):
                    for bad_file in bad_files.get('file'):
                        fix_bad_file(volume_name, bad_file)

            # 同名不同GFID处理
            if result_data.get(DUPGFID_FILE_ERRNO.lower()):
                bad_files = result_data.get(DUPGFID_FILE_ERRNO.lower())
                if bad_files:
                    for bad_file in bad_files.get('file'):
                        fix_dupgfid_file(volume_name, bad_file)

            # 脑裂目录处理
            if result_data.get(BAD_DIR_ERRNO.lower()):
                for bad_files in result_data.get(BAD_DIR_ERRNO.lower()):
                    for bad_file in bad_files.get('file'):
                        fix_bad_dir(bad_file)

            # 处理文件大小不是128MB对齐
            check_lvs_size = glusterfs.get('check_lvs_size')
            result_data = get_result_data(check_lvs_size)
            if result_data.get(MISALIGNED_FILE_ERRNO.lower()):
                for bad_lvs in result_data.get(MISALIGNED_FILE_ERRNO.lower()):
                    lvs = bad_lvs.get('lv')
                    for lv in lvs:
                        fix_misaligned_file(volume_name, lv)

            # 处理文件在分层中残留
            check_efs_trans = glusterfs.get('check_efs_trans')
            result_data = get_result_data(check_efs_trans)
            if result_data.get(TIER_RESIDUE_FILE_ERRNO.lower()):
                for bad_gfids in result_data.get(TIER_RESIDUE_FILE_ERRNO.lower()):
                    brick_path = bad_gfids.get('brick_path')
                    gfids = bad_gfids.get('gfid')
                    for gfid in gfids:
                        fix_tcache_residual_file(brick_path, gfid)
        return 0
    except:
        print '获得异常: {}'.format(traceback.format_exc())
        return -1

if __name__ == "__main__":
    main()
