#!/sf/vs/bin/python
# -*- coding: utf-8 -*-
# vsts_cluster_tool3x.py
from math import radians
import re
import subprocess
import shlex
import os
import time
import argparse
import sys

reload(sys)
sys.setdefaultencoding('utf8')

sys.path.append('/sf/vs/bin/')

cmdlist = {'getfattr': '/sf/vs/bin/getfattr',
           'setfattr': '/sf/vs/bin/setfattr',
           'ls': '/bin/ls',
           'stat': '/sf/bin/busybox/stat',
           'll': '/bin/ls -al'}


# ------------------------------------------------
#   python终端显示彩色字符类，可以调用不同的方法
# 选择不同的颜色.使用方法看示例代码就很容易明白.
# ------------------------------------------------
#
# 显示格式: \033[显示方式;前景色;背景色m
# ------------------------------------------------
# 显示方式             说明
#   0                 终端默认设置
#   1                 高亮显示
#   4                 使用下划线
#   5                 闪烁
#   7                 反白显示
#   8                 不可见
#   22                非粗体
#   24                非下划线
#   25                非闪烁
#
#   前景色             背景色            颜色
#     30                40              黑色
#     31                41              红色
#     32                42              绿色
#     33                43              黃色
#     34                44              蓝色
#     35                45              紫红色
#     36                46              青蓝色
#     37                47              白色
# ------------------------------------------------


class Colored(object):
    # 显示格式: \033[显示方式;前景色;背景色m
    # 只写一个字段表示前景色,背景色默认
    RED = '\033[31m'  # 红色
    GREEN = '\033[32m'  # 绿色
    YELLOW = '\033[33m'  # 黄色
    BLUE = '\033[34m'  # 蓝色
    FUCHSIA = '\033[35m'  # 紫红色
    CYAN = '\033[36m'  # 青蓝色
    WHITE = '\033[37m'  # 白色

    #: no color
    RESET = '\033[0m'  # 终端默认颜色

    def color_str(self, color, s):
        return '{}{}{}'.format(
                getattr(self, color),
                s,
                self.RESET
        )

    def red(self, s):
        return self.color_str('RED', s)

    def green(self, s):
        return self.color_str('GREEN', s)

    def yellow(self, s):
        return self.color_str('YELLOW', s)

    def blue(self, s):
        return self.color_str('BLUE', s)

    def fuchsia(self, s):
        return self.color_str('FUCHSIA', s)

    def cyan(self, s):
        return self.color_str('CYAN', s)

    def white(self, s):
        return self.color_str('WHITE', s)


class MigrateError(Exception):
    pass


def cli(cmdline):
    if not cmdline:
        raise MigrateError("cli input cmd is empty")

    process = subprocess.Popen(shlex.split(cmdline),
                               stdout=subprocess.PIPE,
                               stderr=subprocess.PIPE)

    (stdoutdata, stderrdata) = process.communicate()
    if process.returncode != 0:
        str = ''
        if stdoutdata:
            str += 'stdout: {0:s}'.format(stdoutdata)
        if stderrdata:
            str += 'stderr: {0:s}'.format(stderrdata)
        errstr = "Failed to exec {0:s}. {1:s}".format(cmdline, str)
        raise MigrateError(errstr)

    lines = stdoutdata.split('\n')
    return lines


def cli_show(cmdline):
    if not cmdline:
        raise MigrateError("cli input cmd is empty")

    process = subprocess.Popen(shlex.split(cmdline),
                               stdout=subprocess.PIPE,
                               stderr=subprocess.PIPE)

    (stdoutdata, stderrdata) = process.communicate()
    if process.returncode != 0:
        str = ''
        if stdoutdata:
            str += 'stdout: {0:s}'.format(stdoutdata)
        if stderrdata:
            str += 'stderr: {0:s}'.format(stderrdata)
        errstr = "Failed to exec {0:s}. {1:s}".format(cmdline, str)
        raise MigrateError(errstr)

    # lines = stdoutdata.split('\n')
    return stdoutdata


def remote_cli(host, cmdline):
    if not host or not cmdline:
        raise MigrateError("remote cli input host or cmd is empty")

    # result = remote_check_output(host, cmdline)
    cmdline = "ssh root@{0:s} {1:s}".format(host, cmdline)
    return cli_show(cmdline)


def cluster_cli(current_host, hosts, cmdline):
    result = []
    for host in hosts:
        if host == current_host:
            result += cli(cmdline)
        else:
            result += remote_cli(host, cmdline)

    return result


def get_cluster_info():
    cmdline = "/sf/vs/glusterfs/sbin/gluster vol info"
    lines = cli(cmdline)

    hosts = []
    bricks = []
    for line in lines:
        if line == 'No volumes present':
            continue
        if re.search(r"host-\w{12}:", line):
            brick = {}
            brick_type = ''
            brick_no = int(line.split(':')[0].strip()[5:])
            host = line.split(':')[1].strip()
            if len(line.split(':')[2].strip().split()) == 1:
                path = line.split(':')[2].strip().split()[0]
            else:
                path = line.split(':')[2].strip().split()[0]
                brick_type = line.split(':')[2].strip().split()[1]
            brick['host'] = host
            brick['path'] = path
            if brick_type == '':
                brick['brick_type'] = 'data'
            elif brick_type == '(meta)':
                brick['brick_type'] = 'meta'
            elif brick_type == '(meta-arbiter)':
                brick['brick_type'] = 'meta-arbiter'
            else:
                brick['brick_type'] = 'data-arbiter'

            brick['brick_no'] = brick_no

            hosts.append(host)
            bricks.append(brick)

    return list(set(hosts)), bricks


def _get_rep_and_brickid(replicate, brickpath):
    for k, v in replicate.items():
        for hostbrick in v:
            if hostbrick.split(':')[2] == brickpath:
                return k, hostbrick.split(':')[0]
    return None, None


def data_arbiter_brick_exec_cmd(brick, cmdline, cmd_path, gfid, color_show):
    color = Colored()

    brick_no = brick.get('brick_no')
    host = brick.get('host')
    brick_path = brick.get('path')

    try:
        print 'BD brick_type {0:}  brick_no {1:}  {2:}  {3:}'.\
            format(brick.get('brick_type'), brick_no, host, os.path.join(brick_path, cmd_path))
        cmd = '{0:s} {1:s}'.format(cmdline, os.path.join(brick_path, gfid))
        print cmd
        result = remote_cli(host, cmd)
        if color_show:
            print '{0:}'.format(result)
        else:
            print color.cyan('{0:}'.format(result))
    except MigrateError as e:
        print '{0:}'.format(str(e))


def get_gfid_from_string(result):
    lines = result.split()
    for line in lines:
        if re.search(r"^trusted.gfid", line):
            return line.split('=')[1][2:]
    return ''


now = 0
def meta_brick_exec_cmd(brick, cmdline, cmd_path, shard, color_show):
    color = Colored()

    brick_no = brick.get('brick_no')
    host = brick.get('host')
    brick_path = brick.get('path')
    try:
        if shard == -1 or shard == 0:
            print 'brick_type {0:}  brick_no {1:}  shard {2:}  {3:}  {4:}'.\
                format(brick.get('brick_type'), brick_no, 0, host, os.path.join(brick_path, cmd_path))
               
        if cmdline.split(' ')[0] == 'remove':
            # 针对左子树的删除操作
            global now
            if now == 0:
                now = int(time.time() * 1000000)
            (path, filename) = os.path.split(cmd_path)
            new_path = '.glusterfs/landfill/' + str(now) + '_' + filename
            new_path = os.path.join(brick_path, new_path)
            cmd = '/bin/mv {0:s} {1:s}'.format(os.path.join(brick_path, cmd_path), new_path)
            shard = 0 # 删除不能转shard_path
        else:
            cmd = '{0:s} {1:s}'.format(cmdline, os.path.join(brick_path, cmd_path))
            
        print '{}'.format(cmd)
        result = remote_cli(host, cmd)
        if shard == -1 or shard == 0:
            if color_show:
                print '{0:}'.format(result)
            else:
                print color.cyan('{0:}'.format(result))

        if shard == 0:
            return

        gfid0 = get_gfid_from_string(result)
        shard_path = '{0:}/.vs/shard/{1:}/{2:s}-{3:s}-{4:s}-{5:s}-{6:s}/'.\
            format(brick_path, gfid0[0:2], gfid0[0:8], gfid0[8:12], gfid0[12:16], gfid0[16:20], gfid0[20:32])
        cmd = '/bin/ls {0:s}'.format(shard_path)
        result = remote_cli(host, cmd)
        shards = result.split()
        for shard_file in shards:
            shard_no = int(shard_file.split('.')[1])
            if shard != shard_no and shard != -1:
                continue
            print 'brick_type {0:}  brick_no {1:}  shard {2:}  {3:}  {4:}'.\
                format(brick.get('brick_type'), brick_no, shard_no, host, os.path.join(brick_path, cmd_path))
            cmd = '{0:s} {1:s}'.format(cmdline, os.path.join(shard_path, shard_file))
            result = remote_cli(host, cmd)
            if color_show:
                print '{0:}'.format(result)
            else:
                print color.cyan('{0:}'.format(result))

    except MigrateError as e:
        # print '{0:}'.format(str(e))
        pass


def data_brick_inode_cmd(host, brick_path, gfid, cmdline):
    cmd = '/bin/ps aux | grep {0:} | /bin/grep -v supervise | /bin/grep -v grep'.format(brick_path)
    result = remote_cli(host, cmd)
    pid = result.split()[1]
    
    if cmdline == 'remove':
        efs_cmd = 'itable unlink {0:}'.format(gfid)
    else:
        efs_cmd = 'inode xattr {0:}'.format(gfid)
    efs_cmd = efs_cmd.replace(' ', '\ ').replace('(', '\(').replace(')', '\)').replace('|', '\|')
    cmd = "/sf/vs/sbin/efs_dbg -p {0:} -c '{1:}'".format(pid, efs_cmd)
    result = remote_cli(host, cmd)
    return result


def data_brick_exec_cmd(brick, cmdline, cmd_path, gfid, color_show):
    color = Colored()

    brick_no = brick.get('brick_no')
    host = brick.get('host')
    brick_path = brick.get('path')
    try:
        result = data_brick_inode_cmd(host, brick_path, gfid, cmdline)
        print 'EFS　brick_type {0:}  brick_no {1:}  {2:}  {3:}'.\
            format(brick.get('brick_type'), brick_no, host, os.path.join(brick_path, cmd_path))
        if color_show:
            print '{0:}'.format(result)
        else:
            print color.cyan('{0:}'.format(result))
    except MigrateError as e:
        # print '{0:}'.format(str(e))
        return False
    return True


def is_data_brick_cmd(brick, cmdline, gfid):
    if gfid == '':
        return False

    if brick.get('brick_type') != 'data':
        return False

    if 'getfattr' in cmdline:
        return True

    if 'setfattr' in cmdline:
        return True

    return False


def is_meta_brick_cmd(brick):
    if brick.get('brick_type') == 'meta' or brick.get('brick_type') == 'meta-arbiter':
        return True

    return False


def vs_brick_cmd(hosts, bricks, route, cmdline, cmd_path, gfid, shard, color_show):
    color = Colored()
    if len(route):
        result = True
        for index in route:
            for brick in bricks:
                if int(index) == brick.get('brick_no'):
                    if brick.get('brick_type') == 'data':
                        result = data_brick_exec_cmd(brick, cmdline, cmd_path, gfid, color_show)
                        
                    # 通过EFS查询失败了，再按照BD格式检查一次
                    if brick.get('brick_type') != 'data' or result == False:
                        if cmdline == 'remove':
                            new_cmdline = '/sf/vs/bin/setfattr -n user.glusterfs.rubbish_allow_delete -v 1'
                            data_arbiter_brick_exec_cmd(brick, new_cmdline, cmd_path, gfid, color_show)
                            brick_no = brick.get('brick_no')
                            host = brick.get('host')
                            brick_path = brick.get('path')
                            real_path = os.path.join(brick_path, gfid)
                            gfid_path = os.path.join(brick_path, '.glusterfs/landfill/')
                            new_cmdline = '/bin/mv {} {}'.format(real_path, gfid_path)
                            print new_cmdline
                            try:
                                result = remote_cli(host, new_cmdline)
                            except MigrateError as e:
                                e = str(e)
                                print color.red('{}'.format(e))
                                if "No such file or directory" not in e:
                                    # 不是因为文件不存在抛异常, 直接退出, 防止误操作
                                    raise
                            if color_show:
                                print '{0:}'.format(result)
                            else:
                                print color.cyan('{0:}'.format(result))
                        else:
                            new_cmdline = '/sf/vs/bin/getfattr -d -m . -e hex'
                            data_arbiter_brick_exec_cmd(brick, new_cmdline, cmd_path, gfid, color_show)
    else:
        for brick in bricks:
            if is_meta_brick_cmd(brick):
                meta_brick_exec_cmd(brick, cmdline, cmd_path, shard, color_show)


def exec_brick_cmd():
    parser = argparse.ArgumentParser()
    parser.add_argument('--route', '-r',
                        default='',
                        help='指定需要执行命令的路由.')
    parser.add_argument('--shard', '-s',
                        default='',
                        help='指定需要执行命令的分片.')
    parser.add_argument('--gfid', '-g',
                        default='',
                        help='指定需要执行的命令的gfid.')
    parser.add_argument('--cmd', '-c',
                        default='',
                        help='指定需要执行的命令.')
    parser.add_argument('-n', '--no_show', action="store_true",
                        help='取消着色显示')
    args = parser.parse_args()

    shard = -1
    gfid = ''
    cmdline = ''
    cmd_path = ''
    route = []

    if args.route != '':
        route = args.route.split(':')

    if args.gfid != '':
        gfid = args.gfid

    if args.shard != '':
        shard = int(args.shard)

    if args.cmd:
        if args.cmd == 'remove':
            cmdline = args.cmd
        else:
            cmd = args.cmd.split()[0:-1]
            cmd_update = []
            for c in cmd:
                if cmdlist.get(c):
                    cmd_update.append(cmdlist[c])
                else:
                    cmd_update.append(c)

            cmdline = ' '.join(cmd_update)
            cmd_path = args.cmd.split()[-1]
            if cmd_path[0] == '/':
                cmd_path = cmd_path[1:]

    if args.no_show:
        color_show = True
    else:
        color_show = False

    (hosts, bricks) = get_cluster_info()

    vs_brick_cmd(hosts, bricks, route, cmdline, cmd_path, gfid, shard, color_show)


def main():
    # 打印集群信息
    exec_brick_cmd()


if __name__ == "__main__":
    main()
