#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vsts_cluster_tool2x.py
import re
import subprocess
import shlex
import os
import time
import argparse
import sys

reload(sys)
sys.setdefaultencoding('utf8')

sys.path.append('/sf/vs/bin/')

cmdlist = {'getfattr': '/sf/vs/bin/getfattr',
           'setfattr': '/sf/vs/bin/setfattr',
           'ls': '/bin/ls',
           'stat': '/sf/bin/busybox/stat',
           'll': '/bin/ls -al'}
# ------------------------------------------------
#   python终端显示彩色字符类，可以调用不同的方法
# 选择不同的颜色.使用方法看示例代码就很容易明白.
# ------------------------------------------------
#
# 显示格式: \033[显示方式;前景色;背景色m
# ------------------------------------------------
# 显示方式             说明
#   0                 终端默认设置
#   1                 高亮显示
#   4                 使用下划线
#   5                 闪烁
#   7                 反白显示
#   8                 不可见
#   22                非粗体
#   24                非下划线
#   25                非闪烁
#
#   前景色             背景色            颜色
#     30                40              黑色
#     31                41              红色
#     32                42              绿色
#     33                43              黃色
#     34                44              蓝色
#     35                45              紫红色
#     36                46              青蓝色
#     37                47              白色
# ------------------------------------------------


class Colored(object):
    # 显示格式: \033[显示方式;前景色;背景色m
    # 只写一个字段表示前景色,背景色默认
    RED = '\033[31m'       # 红色
    GREEN = '\033[32m'     # 绿色
    YELLOW = '\033[33m'    # 黄色
    BLUE = '\033[34m'      # 蓝色
    FUCHSIA = '\033[35m'   # 紫红色
    CYAN = '\033[36m'      # 青蓝色
    WHITE = '\033[37m'     # 白色

    #: no color
    RESET = '\033[0m'      # 终端默认颜色

    def color_str(self, color, s):
        return '{}{}{}'.format(
            getattr(self, color),
            s,
            self.RESET
        )

    def red(self, s):
        return self.color_str('RED', s)

    def green(self, s):
        return self.color_str('GREEN', s)

    def yellow(self, s):
        return self.color_str('YELLOW', s)

    def blue(self, s):
        return self.color_str('BLUE', s)

    def fuchsia(self, s):
        return self.color_str('FUCHSIA', s)

    def cyan(self, s):
        return self.color_str('CYAN', s)

    def white(self, s):
        return self.color_str('WHITE', s)


class MigrateError(Exception):
    pass


def cli(cmdline):
    if not cmdline:
        raise MigrateError("cli input cmd is empty")

    process = subprocess.Popen(shlex.split(cmdline),
                               stdout=subprocess.PIPE,
                               stderr=subprocess.PIPE)

    (stdoutdata, stderrdata) = process.communicate()
    if process.returncode != 0:
        str = ''
        if stdoutdata:
            str += 'stdout: {0:s}'.format(stdoutdata)
        if stderrdata:
            str += 'stderr: {0:s}'.format(stderrdata)
        errstr = "Failed to exec {0:s}. {1:s}".format(cmdline, str)
        raise MigrateError(errstr)

    lines = stdoutdata.split('\n')
    return lines


def cli_show(cmdline):
    if not cmdline:
        raise MigrateError("cli input cmd is empty")

    process = subprocess.Popen(shlex.split(cmdline),
                               stdout=subprocess.PIPE,
                               stderr=subprocess.PIPE)

    (stdoutdata, stderrdata) = process.communicate()
    if process.returncode != 0:
        str = ''
        if stdoutdata:
            str += 'stdout: {0:s}'.format(stdoutdata)
        if stderrdata:
            str += 'stderr: {0:s}'.format(stderrdata)
        errstr = "Failed to exec {0:s}. {1:s}".format(cmdline, str)
        raise MigrateError(errstr)

    # lines = stdoutdata.split('\n')
    return stdoutdata


def remote_cli(host, cmdline):
    if not host or not cmdline:
        raise MigrateError("remote cli input host or cmd is empty")

    # result = remote_check_output(host, cmdline)
    cmdline = "/usr/bin/ssh root@{0:s} {1:s}".format(host, cmdline)
    return cli_show(cmdline)


def cluster_cli(current_host, hosts, cmdline):
    result = []
    for host in hosts:
        if host == current_host:
            result += cli(cmdline)
        else:
            result += remote_cli(host, cmdline)

    return result


def get_cluster_info():
    cmdline = "/sf/vs/glusterfs/sbin/gluster vol info"
    lines = cli(cmdline)

    replicate_num = 2
    hosts = []
    replicate = {}
    bricks = {}
    i = -1
    for line in lines:
        m_replicate_num = re.search(r"vs_vol_rep\d", line)
        if m_replicate_num:
            replicate_num = int(m_replicate_num.group()[10:])
        if line == 'No volumes present':
            continue
        if re.search(r"host-\w{12}:", line):
            brickId = line.split(':')[0].strip()
            host = line.split(':')[1].strip()
            path = line.split(':')[2].strip().split()[0]
            brickpath = '{0:s}:{1:s}:{2:s}'.format(brickId, host, path)
            hosts.append(host)
            if not re.search(r"(arbiter)", line):
                i += 1
            rep = i / replicate_num
            if not replicate.get(rep):
                replicate[rep] = []
            replicate[rep].append(brickpath)

            if not bricks.get(host):
                bricks[host] = []
            bricks[host].append(path)

    return list(set(hosts)), replicate_num, replicate, bricks


def _get_rep_and_brickid(replicate, brickpath):
    for k, v in replicate.items():
        for hostbrick in v:
            if hostbrick.split(':')[2] == brickpath:
                return k, hostbrick.split(':')[0]
    return None, None


def vs_brick_cmd(replicate, bricks, cmdline, paths, rep, color_show):
    # 打印某一个复制组
    color = Colored()
    if rep >= 0:
        if not replicate.get(rep):
            print color.red('Cannot find replicate {0:}'.format(rep))
            return

        for hostbrick in replicate.get(rep):
            brickId = hostbrick.split(':')[0]
            host = hostbrick.split(':')[1]
            brickpath = hostbrick.split(':')[2]
            cmd = '{} '.format(cmdline)
            for path in paths:
                cmd = '{} {}'.format(cmd, os.path.join(brickpath, path))
            print 'replicate:{0:} {1:}  {2:}  {3:}'.format(rep, brickId, host, cmd)
            try:
                result = remote_cli(host, cmd)
                if color_show:
                    print '{0:}'.format(result)
                else:
                    print color.cyan('{0:}'.format(result))
            except MigrateError as e:
                print '{0:}'.format(str(e))
    else:
        # 打印所有复制组
        for k, v in bricks.items():
            for brickpath in v:
                (repId, brickId) = _get_rep_and_brickid(replicate, brickpath)
                cmd = '{} '.format(cmdline)
                for path in paths:
                    cmd = '{} {}'.format(cmd, os.path.join(brickpath, path))
                try:
                    result = remote_cli(k, cmd)
                    if color_show:
                        print 'replicate:{0:} {1:}  {2:}  {3:}'.format(repId, brickId, k, cmd)
                        print '{0:}'.format(result)
                    else:
                        print 'replicate:{0:} {1:}  {2:}  {3:}'.format(repId, brickId, k, cmd)
                        print color.cyan('{0:}'.format(result))
                except MigrateError as e:
                    # print '{0:}'.format(str(e))
                    pass


def exec_brick_cmd():
    parser = argparse.ArgumentParser()
    parser.add_argument('--replicate', '-r',
                        default='',
                        help='指定需要执行命令的复制组.')
    parser.add_argument('--cmd', '-c',
                        default='',
                        help='指定需要执行的命令.')
    parser.add_argument('-n', '--no_show', action="store_true",
                        help='取消着色显示')
    args = parser.parse_args()

    rep = -1

    if args.cmd == '':
        print "请输入需要执行的命令"
        return

    if args.replicate != '':
        rep = int(args.replicate)

    # 针对mv进行特殊处理，支持两个path
    if args.cmd.split()[0] == 'mv':
        cmd = args.cmd.split()[0:-2]
        paths = args.cmd.split()[-2:]
    # 针对remve操作，延时删除文件
    elif args.cmd.split()[0] == 'remove':
        cmd = ['mv']
        paths = args.cmd.split()[-1:]
        now = int(time.time() * 1000000)
        (path, filename) = os.path.split(paths[0])
        paths.append('/.glusterfs/landfill/' + str(now) + '_' + filename)
    else:
        cmd = args.cmd.split()[0:-1]
        paths = args.cmd.split()[-1:]
    cmd_update = []

    for c in cmd:
        if cmdlist.get(c):
            cmd_update.append(cmdlist[c])
        else:
            cmd_update.append(c)

    cmdline = ' '.join(cmd_update)
    new_paths = []
    for path in paths:
        if path[0] == '/':
            new_paths.append(path[1:])
        else:
            new_paths.append(path)
    # print rep
    # print cmdline
    # print path
    if args.no_show:
        color_show = True
    else:
        color_show = False

    (hosts, replicate_num, replicate, bricks) = get_cluster_info()
    # print replicate
    # print bricks
    # cmdline = 'ls -al'
    # path = 'images/cluster/'
    # rep = 0
    
    # 针对remove操作，设置user.glusterfs.rubbish_allow_delete属性
    if args.cmd.split()[0] == 'remove':
        tmp_cmdline = '/sf/vs/bin/setfattr -n user.glusterfs.rubbish_allow_delete -v 1'
        tmp_paths = new_paths[:-1]
        vs_brick_cmd(replicate, bricks, tmp_cmdline, tmp_paths, rep, color_show)
        
    vs_brick_cmd(replicate, bricks, cmdline, new_paths, rep, color_show)


def main():
    # 打印集群信息
    exec_brick_cmd()


if __name__ == "__main__":
    main()
