# vsfire工具

提供给技术支持的工具，版本v1.0

## 一级命令集

            disk                磁盘自替换以及磁盘配置修复
            network             网络相关工具
            badsector           坏道修复
  vsfire    splitbrain          两主机脑裂自动修复
            shard               双点故障梳理以及分片残留清理
            tier                分层元数据恢复以及运维操作
            rebalance           vs2.x平衡工具
            nfsclnt_rpc         nfs rpc相关操作，目前只有打开/关闭iolog
            datarecover         vs2.x lvm误删之后的恢复



## 二级命令集
### 分层元数据恢复工具

#### 场景说明
该工具主要用于处理分层元数据损坏导致分层无法启动。技术支持曾经遇到过2个问题

1. 卷创建完成后，一线通过dd命令把分层磁盘元数据写0了，然后系统一直正常运行，知道tierd进程发生重启，重新加载分层元数据
2. 分层SSD元数据区域坏块

针对问题1:
- 如果由于dd损坏的区域不超过元数据区即可通过本工具恢复，因为损坏区域大部分未写过，并且无法通过crc校验的。

针对问题2:
- 如果损坏的是超级块，可以通过超级块备份恢复备份在/sf/cfg/vs/cache/目录下，
- 如果损坏的是brick/inode区，可以通过日志找到对应的brick信息进行恢复

#### 命令说明

```shell
vsfire.py tier filter_brick [--log_path]
通过分层日志过滤出有效的brick信息，注意如果有磁盘替换可能会不准确

vsfire.py tier filter_inode [--log_path]
通过分层日志过滤出有效的inode信息，注意如果有磁盘替换可能会不准确

vsfire.py tier restore_brick [--ssd_path|--brickno|--brickid]
通过brickno和brickid恢复brick

vsfire.py tier restore_brick_from_tierlog [--ssd_path|--log_path]
通过分层日志自动解析出brick信息，并恢复这些brick，需要注意的是如果分层日志已经发生过轮转就会不准确

vsfire.py tier restore_brick_batch [--ssd_path|--input_path]
通过input文件批量恢复brick，需要注意input文件内容的格式为no brickid

vsfire.py tier restore_inode [--ssd_path|--brickno|--uuid|--no]
通过no/brickid/uuid/恢复inode信息

vsfire.py tier restore_inode_from_tierlog [--ssd_path|--log_path]
通过分层日志自动解析出inode信息，并恢复这些inode，需要注意的是如果分层日志已经发生过轮转就会不准确

vsfire.py tier restore_inode_batch [--ssd_path|--input_path]
通过input文件批量恢复inode，需要注意input文件内容的格式为no gfid brickno

vsfire.py tier restore_extent [--ssd_path]
自动识别SSD中非法extent，并把其格式化成初始化状态

vsfire.py tier expand
SSD热扩容工具，支持HCI630 ~ HCI6100版本，以及EDS309-EDS502版本

vsfire.py tier capleak_fix
修复分层空间泄露问题
```


### 磁盘自替换工具

#### 场景说明
- 某些场景之下，磁盘里面的数据损坏了，但是磁盘是好的，需要把磁盘重新利用起来。  
  插拔磁盘之后，由于同一个磁盘的scsi id不变，导致无法识别到新的磁盘，也就无法通过自身来替换数据损坏的磁盘。
- 在替换过raid卡之后，可能会出现硬盘的scsi id变化的问题，由于硬盘配置不会自动应对这种变化，会导致替换raid卡后，硬盘全部离线的问题。
  针对上述问题，本工具提供一个磁盘字体换以及修复硬盘UUID的功能

#### 命令说明

```shell
./vsfire.py disk self_replace scsi_id
# 磁盘自替换，需要先获取磁盘scsi id,在/sf/cfg/vs/disk/目录下，文件名就是hostname_scsiid

./vsfire.py disk diskuuid_repair
# 磁盘UUID修复：如果是2.x环境，会直接修复；如果是3.x环境，会提示输入旧硬盘UUID合新硬盘UUID。
# 3.x环境中，如何确认旧硬盘UUID和新硬盘UUID：https://docs.atrust.sangfor.com/pages/viewpage.action?pageId=190113315
```



### 残留分片清理
- 左子树删除文件的时候，由于某个副本离线，导致该副本文件未被删除；在删除该文件父目录的时候，此时离线的brick重新上线，  
  此时，目录会删除报错。后续，被删除的文件会被修复出来。由此，而产生了左子树的垃圾文件，而右子树的数据实际上已经被删除掉了。
  针对该问题，本工具提供一个自动清理残留分片的工具

#### 命令说明
```shell
./vsfire.py shard meta_clear ${gfid}
# 左子树残留清理

./vsfire.py shard subshard_clear
# 子分片残留清理

./vsfire.py shard faultshow_host $(hostname)
# 对指定故障主机的受损分片的梳理

./vsfire.py shard faultshow_bricks ${disk_cfg1, disk_cfg2, }
# 对指定故障磁盘的受损分片的梳理

./vsfire.py shard faultshow_doublefailure
# 梳理所有双点分片对应的文件名

./vsfire.py shard lba2file ${DISK} ${MOUNTPOINT} ${ADDRESS}
根据裸盘的坏道偏移定位出对应偏移上运行了哪些虚拟机
```



### 坏道修复工具

#### 场景说明
- 1.看集群所有虚拟机双点故障分析，显示所有虚拟机分片以及route对应brick状态，判断是否存在双点故障
- 2.单独查看单个虚拟机故障情况，与功能一类似，显示指定虚拟机故障分片情况
- 3.修复一个数据副本和一个仲裁副本导致双点的虚拟机。
- 4.一个副本有bad，另外一个好副本有坏道，期望用坏副本修好副本的坏道
  要求覆盖2.x，3.x版本
- 5.抹bad前检查工具（做一些检查，先检测指控、dirty、bad等信息，人为确认是否去抹bad）。

#### 命令说明

```shell
./vsfire.py badsector show_fault_kvm
#显示所有虚拟机数据副本状态

./vsfire.py badsector show_fault_shard ${vmid}
#显示指定虚拟机所有故障的分片

./vsfire.py badsector arbiter_migrate ${gfid} ${arbiter}
#2+1场景 通过单一正常分片修复仲裁

./vsfire.py badsector fix_kvm_arbiter ${vmid} ${arbiter}
#2+1场景 通过单一正常副本修复仲裁 修复某一台虚拟机的所有分片

./vsfire.py badsector badsector_repair_v2 ${dev} ${offset}
#vs2.x 2+1场景 用有bad无坏道的数据副本修复有坏道的good数据副本 vs2.x场景无法通过工具自动扫描坏道位置 输入参数需要知道坏道位置 

./vsfire.py badsector badsector_repair_v3 ${gfid} ${volume}
#vs3.x 2+1场景 用有bad无坏道的数据副本修复有坏道的good数据副本

./vsfire.py badsector remove_bad_attr ${gfid}
#vs3.x 移除gfid对应文件的bad状态 流程会先提示指控dirty和bad日志 然后是否进行抹bad 
```


### 2主机脑裂修复以及非BD文件脑裂修复工具

#### 场景说明

- 2主机bd文件发生了脑裂，可以用此工具修复，会修复前备份到挂载点下 /sf/data/vs/gfs/a0eee49e_vs_vol_rep2/backup_qcow2/

#### 命令说明

```shell
./vsfire.py splitbrain qcow2_repair
# 自动修复脑裂文件，适用于2.x和3.x

./vsfire.py splitbrain tfile_repair
# 自动清理T文件，适用于2.x

./vsfire.py splitbrain vmcfg_repair [$path]
# 自动修复脑裂的虚拟机配置文件
```


### 网络相关工具
#### 场景说明
- 提供网络抓包、网口清理、网卡中断核重新绑定等功能

####

```shell
./vsfire.py network if_clear
# 存储网口清理

./vsfire.py network capture
# 指定网口抓包

```


### 2.x版本平衡工具

#### 场景说明

- vs2.x版本平衡工具

####

```shell
./vsfire.py rebalance rebalance_file ${path}
# 手动平衡指定的文件，实际上就是cp，cp后不会自动删除原文件

./vsfire.py rebalance check_file ${vg} ${volume_id}
# 检查指定vg的容量使用情况

./vsfire.py rebalance check_vgs
# 检查卷内vg的整体使用情况

```


### lvm数据恢复工具

#### 场景说明
- vs2.x虚拟机误删后的恢复

####

```shell
./vsfire.py datarecover ${gfid}
# 恢复指定gfid的lvm配置

./vsfire.py datarecover $path $gfid
# 恢复指定gfid的lvm
```
