#根据GFID查找inode
define show_inode_by_gfid
    set $itable = ((xlator_t *)glusterfsd_ctx->active->top).itable
    set $offset = (int64_t)(&((struct _inode*)0)->list)
    set $inode  = 0

    set $pos = (struct _inode*)((int64_t)($itable->active.next) - $offset)
    while ( &$pos->list != &$itable->active)
        if ( 0 == strcmp(uuid_utoa($pos->gfid), $arg0) )
            set $inode = $pos
        end
        set $pos = (struct _inode*)((int64_t)($pos->list.next) - $offset)
    end

    if (0 == $inode)
        set $pos = (struct _inode*)((int64_t)($itable->lru.next) - $offset)
        while ( &$pos->list != &$itable->lru)
        if ( 0 == strcmp(uuid_utoa($pos->gfid), $arg0) )
            set $inode = $pos
        end
            set $pos = (struct _inode*)((int64_t)($pos->list.next) - $offset)
        end
    end
    p $inode
end

#更新inode的路由
define update_inode_data_arbiter_route
    set $xlator = (xlator_t *)(glusterfsd_ctx->active->top)
    set $offset = (int64_t)(&((struct _inode*)0)->list)
    set $inode  = 0
    set $itable = 0

    # 在xlator链表中找到第一个可用的itable
    while($xlator != 0)
        if ($xlator.itable != 0)
            set $itable = $xlator.itable
            loop_break
        end
        set $xlator = $xlator.next
    end

    # 遍历itable里所有的_inode 找到gfid对应的inode
    set $pos = (struct _inode*)((int64_t)($itable->active.next) - $offset)
    while ( &$pos->list != &$itable->active)
        if ( 0 == strcmp(uuid_utoa($pos->gfid), $arg0) )
            set $inode = $pos
        end
        set $pos = (struct _inode*)((int64_t)($pos->list.next) - $offset)
    end

    # 没有在active里找到inode的话就从lru里找
    if (0 == $inode)
        set $pos = (struct _inode*)((int64_t)($itable->lru.next) - $offset)
        while ( &$pos->list != &$itable->lru)
        if ( 0 == strcmp(uuid_utoa($pos->gfid), $arg0) )
            set $inode = $pos
        end
            set $pos = (struct _inode*)((int64_t)($pos->list.next) - $offset)
        end
    end
    p $inode

    # 如果找到了对应的inode 并且inode对应路由也是2+1
    if (0 != $inode)
        if (REP_TWO_PLUS_ONE == $inode->i_route[XLATOR_TYPE_DATA].rt_info->rep_type)
            set $route = $inode->i_route[XLATOR_TYPE_DATA].rt_info

            # 打印一下路由和前三元素
            p *$route
            p  $route->rt[0]@3

            # 直接将仲裁副本的路由修改成参数对应brick，并修改对应crc
            set $route->rt[2] = $arg1
            set $route->crc = rt_calc_route_crc($route)

            p *$route
            p $route->rt[0]@3
        end
    end
end