#!/usr/bin/env python
# -- coding: utf-8 --
# 接口仅对内部数据信息处理，正常情况此文件内接口不要print控制台信息和log信息
import json
import re
import os
import pylib.utils.color as color
from pylib.fault_recover.data_plane_info import _vs_list_file, _vs_get_clnt
from pylib.utils.utiltools import cli, remote_cli, logger, get_vs_version


class Brick:
    id = None
    hostname = None
    path = None
    pid = None
    type = None

    def __init__(self):
        pass

    def __str__(self):
        return str(self.id) + str(self.hostname) + str(self.path) + str(self.pid) + str(self.type)


class DataShard:
    gfid = None
    hostname = None
    path = None
    route = None
    type = None

    def __init__(self):
        pass


def _all_vmid():
    # """获取所有虚拟机的vmid"""
    if get_vs_version() >= '3.3.0':
        from libvs.utils.vs_get_from_vt import vt_get_vms
        get_vm_func = vt_get_vms
    else:
        from libvs.utils.vs_get_from_vt import vtpsh_get_vms
        get_vm_func = vtpsh_get_vms
    res = list()
    try:
        vms = get_vm_func()
    except Exception as ex:
        print("migrate arbiter Error!")
        logger.exception("{}".format(ex))
        return res
    return [vm.get('vmid') for vm in vms]


def _get_cluster_info_2():
    cmdline = "/sf/vs/glusterfs/sbin/gluster vol info"
    lines = cli(cmdline)

    replicate_num = 2
    has_arbiter = False
    hosts = []
    replicate = {}
    bricks = {}
    i = -1
    for line in lines:
        m_replicate_num = re.search(r"vs_vol_rep\d", line)
        if m_replicate_num:
            replicate_num = int(m_replicate_num.group()[10:])
        if line == 'No volumes present':
            continue
        if re.search(r"host-\w{12}:", line):
            brickId = line.split(':')[0].strip()
            host = line.split(':')[1].strip()
            path = line.split(':')[2].strip().split()[0]
            brickpath = '{0:s}:{1:s}:{2:s}'.format(brickId, host, path)
            hosts.append(host)
            if not re.search(r"(arbiter)", line):
                i += 1
            else:
                has_arbiter = True
            rep = i / replicate_num
            if not replicate.get(rep):
                replicate[rep] = []
            replicate[rep].append(brickpath)

            if not bricks.get(host):
                bricks[host] = []
            bricks[host].append(path)

    return list(set(hosts)), has_arbiter, replicate_num, replicate, bricks


def _get_cluster_info_3():
    cmdline = "/sf/vs/glusterfs/sbin/gluster vol info"
    lines = cli(cmdline, split=True)

    hosts = set()
    bricks = []
    for line in lines:
        if line == 'No volumes present':
            continue
        if re.search(r"host-\w{12}:", line):
            brick_type = ''
            line = line.split(':')
            host = line[1].strip()
            hosts.add(host)

            if len(line[2].strip().split()) == 1:
                path = line[2].strip().split()[0]
            else:
                path = line[2].strip().split()[0]
                brick_type = line[2].strip().split()[1]

            brick = Brick()
            brick.id = int(line[0].strip()[5:])
            brick.hostname = host
            brick.path = path

            if brick_type == '':
                brick.type = 'data'
            elif '(meta)' in brick_type:
                brick.type = 'meta'
            elif '(meta-arbiter)' in brick_type:
                brick.type = 'meta-arbiter'
            else:
                brick.type = 'data-arbiter'

            bricks.append(brick)

    return list(hosts), bricks


def _vmid2gfid(vmid):
    # """
    # :param vmid:虚拟机id
    # :return:虚拟机首分片gfid
    # """
    file_path = "/sf/data/vs/gfs/*/images/cluster/{}.vm/vm-disk-1.qcow2".format(vmid)

    # 通过路径获取gfid
    cmd = r"getfattr -n glusterfs.gfid.string %s |grep -v file |grep -Eo '(\w+-)+\w+'" % file_path
    try:
        result = cli(cmd)
    except Exception:
        raise
    gfid = result.replace("\n", "").strip()
    if gfid == '':
        print('can not get gfid {}'.format(gfid))
        return -1
    return gfid


def _gfid2route(gfid):
    # 下面的{{}}是为了避免python识别成format参数
    meta_brick_id = _get_meta_brick()[0]['brick'].strip('Brick')
    # 选择一个元数据brick，要求rpc查询所有分片
    res = _vs_list_file(brick_no=int(meta_brick_id), gfid=None)
    if not res['ret']:
        print("list brick failed")
        return False
    all_files = res['files']
    for duplicate in all_files:
        if gfid in duplicate['gfid']:
            return duplicate['route_info']
    raise ValueError("找不到对应gfid的route信息")


def _brickinfo():
    # """返回gluster v i的格式化信息"""
    bricks_info = []
    keys = ['brick', 'host', 'path', 'type']
    fd = os.popen("gluster v i|grep -E 'Brick[0-9]'|grep -v VG|sed -e 's/:/ /g'|sed -e 's/(/ /g'|sed -e 's/)/ /g'")
    while True:
        brick_info = fd.readline()
        if not brick_info:
            break
        bricks_info.append(dict(zip(keys, brick_info.split())))
    for brick in bricks_info:
        brick['brick'] = int(brick['brick'].replace('Brick', ''))
    return bricks_info


def _brickid2brickinfo(brickid):
    # """从gluster v i列表中查找对应brick id的信息"""
    brick_info = _brickinfo()
    for node in brick_info:
        if int(node['brick']) == int(brickid):
            info = node
            break

    if not info:
        print(color.red("没有找到对应brick！"))
        return None

    cmd = "ps auxwww | grep {} | grep glusterfsd|grep -v super |grep -v grep".format(info['path'])
    info['pid'] = remote_cli(info['host'], cmd).strip().split()[1]
    return info


def _get_meta_brick():
    # """
    # 返回元数据brick
    # :return:    [Brick609  host-000c29310a1c 磁盘路径  meta]
    # """
    meta_brick = []
    res = cli("gluster v i|grep meta|sed -e 's/:/ /g'|sed -e 's/(/ /g'|sed -e 's/)/ /g'", split=True)
    if not res:
        print("没有找到meta brick!")
        return []
    for line in res:
        keys = ['brick', 'host', 'path', 'type']
        tempinfo = dict(zip(keys, line.split()))
        meta_brick.append(tempinfo)
    return meta_brick


def _get_brick_meta_route():
    # """读取一个元数据brick上所有文件路由信息"""
    try:
        meta_brick_id = _get_meta_brick()[0]['brick'].strip('Brick')
        print("meta_brick_id is %s" % meta_brick_id)
        res = _vs_list_file(brick_no=int(meta_brick_id), gfid=None)
        if not res['ret']:
            print("list brick failed")
            return False
        all_files = res['files']

        # 读取所有brick状态，用于判断故障分片是不是双点故障
        dump_obj = _vs_get_clnt()
        if not dump_obj:
            print("gfid:{} get clnt failed")
            return False

        mdict = {}
        for mroute in dump_obj["brick"]:
            mdict[mroute["no"]] = mroute["status"]
    except Exception as ex:
        print ex
        return [], []

    return all_files, mdict


def _gfids_in_file(_gfids, _duplicate):
    for _gfid in _gfids:
        if _gfid <= 0:
            continue
        if _gfid in _duplicate['gfid'] or _gfid in _duplicate['path']:
            return _gfid
    return -1


def _get_good_routes(routes, mdict):
    # """
    # 返回所有routes副本状态
    # :param routes: [ 16,6,26]
    # :param mdict: {"15":"NORMAL","16":"NORMAL"}
    # :return:每个brick的状态[0,-1,0]
    # """
    ret = []
    for route in routes:
        if mdict[route] != "NORMAL":
            ret.append(-1)
        else:
            ret.append(0)
    return ret


def _getfattr_from_meta(meta_brick, gfid, _filter=None):
    from libvs.volume.route import RouteMgr
    try:
        host = meta_brick.split(':')[0]
        path = meta_brick.split(':')[1]
        path += "/.glusterfs/" + gfid[0:2] + "/" + gfid[2:4]
        cmd = '/sf/vs/bin/vs_ssh root@{} /sf/vs/bin/getfattr -d -m . -e hex \"{}/{}\" ' \
              '2>/dev/null'.format(host, path, gfid)

        # vs2.x低版本扩展属性没有route
        route_mgr = RouteMgr()

        route_str = ""
        attr_fd = os.popen(cmd)
        while True:
            attr = attr_fd.readline()
            if not attr:
                break
            if _filter is not None and attr.startswith(_filter):
                route_str = attr[len(_filter)]
            elif attr.startswith("trusted.route.info="):
                route_str = attr[len("trusted.route.info=")]

        if not route_str:
            return {}

        return route_mgr.parse_route(route_str)

    except Exception as ex:
        print("get route Error!")
        logger.exception("{}".format(ex))
    return {}


def _setfattr_to_meta(brick, gfid, route):
    from libvs.volume.route import RouteMgr
    try:
        host = brick.split(':')[0]
        path = brick.split(':')[1]
        path += "/.glusterfs/" + gfid[0:2] + "/" + gfid[2:4] + "/" + gfid

        route_mgr = RouteMgr()
        value = route_mgr.format_route(3, 1, route['rt'])
        if not value:
            print("gfid:{} route:{} format failed".format(gfid, route))
            return False

        cmd = '/sf/vs/bin/vs_ssh root@{} /sf/vs/bin/setfattr -n trusted.route.info -v {} {} ' \
              '2>/dev/null'.format(host, value, path)
        ret = os.system(cmd)
        if ret != 0:
            print("gfid:{} cmd:{} ret:{}".format(gfid, cmd, ret))
            return False

        print("gfid:{} cmd:{} success".format(gfid, cmd))
        return True

    except Exception as ex:
        print("set route Error!")
        logger.exception("{}".format(ex))
    return False


def _remove_xattr(_host, _remove, _file):
    try:
        cmd = '/sf/vs/bin/vs_ssh root@{} /sf/vs/bin/setfattr -x {} {} ' \
              '2>/dev/null'.format(_host, _remove, _file)
        ret = os.system(cmd)
        if ret != 0:
            print("cmd:{} ret:{}".format(cmd, ret))
            return False

        print("cmd:{} success".format(cmd))
        return True
    except Exception as ex:
        print("set route Error!")
        logger.exception("{}".format(ex))
    pass


def _set_route_to_ebd(brick, gfid, route):
    from libvs.volume.route import RouteMgr
    try:
        print("gfid:{} brick:{} set route:{}".format(gfid, brick, route))
        host = brick.strip().split(':')[0]
        path = brick.strip().split(':')[1]
        cmd = "/sf/vs/bin/vs_ssh root@{} \'ps auxwww | grep {} | grep glusterfsd" \
              "|grep -v super |grep -v grep\'".format(host, path)
        print(cmd)
        pid = os.popen(cmd).readline().strip().split()[1]
        if not pid:
            print("gfid:{} cmd:{} get efs pid failed")
            return False

        route_mgr = RouteMgr()
        value = route_mgr.format_route(3, 1, route['rt'])
        if not value:
            print("gfid:{} route:{} format failed".format(gfid, route))
            return False

        cmd = '/sf/vs/bin/vs_ssh root@{} \'/sf/vs/sbin/efs_dbg -p {} ' \
              '-c \"inode xattr set {} trusted.route.info={}\"\''.format(host, pid, gfid, value)
        ret = os.system(cmd)
        if ret != 0:
            print("gfid:{} cmd:{} ret:{}".format(gfid, cmd, ret))
            return False

        print("gfid:{} cmd:{} set ebd route success".format(gfid, cmd))
        return True

    except Exception as ex:
        print("set route Error!")
        logger.exception("{}".format(ex))
    return False


def _create_and_fill_arbiter(gfid, route, bno):
    # """通过一个数据副本创建一个仲裁副本"""
    try:
        # 创建新的arbiter文件
        fd = os.popen("gluster v i | grep -w Brick{}".format(route['rt'][2]))
        brick = fd.readline().strip().split()[1]
        if not brick:
            print("gfid:{} get arbiter brick failed".format(gfid))
            return False

        arbiter_host = brick.split(':')[0]
        arbiter_path = brick.split(':')[1] + "/" + gfid
        cmd = '/sf/vs/bin/vs_ssh root@{} touch {}'.format(arbiter_host, arbiter_path)
        print(cmd)

        ret = os.system(cmd)
        if 0 != ret:
            print("gfid:{} cmd failed".format(gfid))
            return False

        # 从好副本中获取到文件扩展属性
        fd = os.popen("gluster v i | grep -w Brick{}".format(bno))
        brick = fd.readline().split()[1]
        host = brick.split(':')[0]
        path = brick.split(':')[1]
        cmd = "/sf/vs/bin/vs_ssh root@{} \'ps auxwww | grep {} " \
              "| grep -v supervise | grep -v grep\'".format(host, path)

        print(cmd)
        fd = os.popen(cmd)
        pid = fd.readline().strip().split()[1]
        if not pid:
            print("gfid:{} cmd:{} failed".format(gfid, cmd))
            return False

        # 设置gfid扩展属性
        cmd = "/sf/vs/bin/vs_ssh root@{} \'/sf/vs/bin/setfattr " \
              "-n trusted.gfid -v 0x{} {}\'".format(arbiter_host, gfid.replace('-', ''), arbiter_path)
        print(cmd)
        ret = os.system(cmd)
        if ret != 0:
            print("gfid:{} cmd:{} ret:{}".format(gfid, cmd, ret))
            return False

        cmd = "/sf/vs/bin/vs_ssh root@{} \'/sf/vs/bin/setfattr -n trusted.parentgfid" \
              " -v 0x00000000000000000000000000000001 {}\'".format(arbiter_host, arbiter_path)
        print(cmd)
        ret = os.system(cmd)
        if ret != 0:
            print("gfid:{} cmd:{} ret:{}".format(gfid, cmd, ret))
            return False

        cmd = "/sf/vs/bin/vs_ssh root@{} '/sf/vs/sbin/efs_dbg " \
              "-p {} -c \"inode xattr {} hex\"'".format(host, pid, gfid)
        print(cmd)
        fd = os.popen(cmd)
        while True:
            attr_info = fd.readline().strip()
            print(attr_info)
            if not attr_info:
                break
            if -1 == attr_info.find("="):
                continue

            name = attr_info.split("=")[0]
            value = attr_info.split("=")[1]
            cmd = "/sf/vs/bin/vs_ssh root@{} '/sf/vs/bin/setfattr " \
                  "-n {} -v {} {}'".format(arbiter_host, name, value, arbiter_path)
            ret = os.system(cmd)
            if ret != 0:
                print("gfid:{} cmd:{} ret:{}".format(gfid, cmd, ret))
                return False
            print("cmd:{} success".format(cmd))
        return True

    except Exception as ex:
        print("set route Error!")
        logger.exception("{}".format(ex))
    return False


def _gdb_update_route(host, pid, gfid, bid):
    try:
        cmd = "/sf/vs/bin/vs_ssh root@{} ".format(host)
        cmd += "\"gdb -p {}  -ex \'./source update_route.gdb\' " \
               "-ex \'update_inode_data_arbiter_route \\\"{}\\\" {}\' --batch\"".format(pid, gfid, bid)
        print(cmd)
        ret = os.system(cmd)
        if ret == 0:
            return True

        print(cmd + " failed")
        return False
    except Exception as ex:
        print("modify cache route Error!")
        logger.exception("{}".format(ex))
        return False


def _modify_cache_route_info(host_list, gfid, route, bno):
    try:
        # 更新glusterfs的内存路由
        print("gfid:{} update glusterfs cache route".format(gfid))
        for host in host_list:
            cmd = "/sf/vs/bin/vs_ssh root@{} ps auxwww | grep nfs.pid " \
                  "| grep -v supervise | grep -v grep".format(host)
            print cmd

            pid = os.popen(cmd).readline().strip().split()[1]
            if not pid:
                print("gfid:{} cmd:{} failed".format(gfid, cmd))
                return False

            _gdb_update_route(host, pid, gfid, route['rt'][2])

        print("gfid:{} update tgtd cache route".format(gfid))
        # 更新tgtd的内存路由
        for host in host_list:
            cmd = "/sf/vs/bin/vs_ssh root@{} ps auxwww | grep tgtd " \
                  "| grep -v supervise | grep -v grep | grep -v node".format(host)
            pid = os.popen(cmd).readline().split()[1]
            if not pid:
                print("gfid:{} cmd:{} failed".format(gfid, cmd))
            _gdb_update_route(host, pid, gfid, route['rt'][2])

        print("gfid:{} update glusterfsd cache route".format(gfid))
        # 更新服务端内存路由
        fd = os.popen("gluster v i | grep host | grep -w Brick{}".format(bno))
        brick = fd.readline().strip().split()[1]
        if not brick:
            print("gfid:{} cmd:{} failed".format(gfid, cmd))
            return False

        host = brick.split(':')[0]
        path = brick.split(':')[1]
        cmd = "/sf/vs/bin/vs_ssh root@{} ps auxwww | grep {} | grep glusterfsd " \
              "| grep -v supervise | grep -v grep".format(host, path)
        print(cmd)
        pid = os.popen(cmd).readline().strip().split()[1]
        if not pid:
            print("gfid:{} cmd:{} failed".format(gfid, cmd))
            return False

        _gdb_update_route(host, pid, gfid, route['rt'][2])
        return True

    except Exception as ex:
        print("modify cache route Error!")
        logger.exception("{}".format(ex))
        return False
