#!/usr/bin/env python
# -- coding: utf-8 --
# VS3.x以上版本直接使用vs_rpc_tool命令获取数据面信息的接口
import json
import re
from collections import OrderedDict

from pylib.utils.utiltools import cli, logger


def _vs_list_file(brick_no, gfid=None):
    info = {
        'ret': True,
        'errno': 0,
        'files': []
    }

    cmdline = '/sf/vs/bin/vs_rpc_tool --cmd list --brickno {} '.format(brick_no)
    lines = cli(cmdline, split=True)
    for line in lines:
        # 去掉所有空字符，然后按 | 分割
        strlist = re.sub('\s', '', line).split('|')
        if len(strlist) <= 10:
            continue
        tmp_list1 = strlist[2].split('/')
        if len(tmp_list1) < 3:
            continue
        # tmp_list2 = tmp_list1[5].split('.')
        # if len(tmp_list2) < 3:
        #     continue
        # if tmp_list2[2] != "shard" or (gfid and tmp_list2[0] != gfid):
        #     continue

        file_info = {
            "gfid": strlist[1],
            "path": strlist[2],
            "file_size": int(strlist[3]),
            "file_blocks": int(strlist[4]),
            "route_version": int(strlist[5]),
            # "route_info": [int(route) for route in re.sub(r'[\[\]]', '', strlist[6]).split(',')],
            "route_info": json.loads(strlist[6]),
            "replica": None,
            "tier": None,
            "writecache": strlist[7],
            "op_ret": None,
            "prio": strlist[8],
            "api_open": strlist[9]
        }

        info['files'].append(file_info)

    return info


def _vs_get_clnt():
    return json.loads(cli("vs_rpc_tool --cmd clnt"), object_pairs_hook=OrderedDict)
