#!/bin/bash

pidof tierd
if [ $? -ne 0 ]; then
    echo "未检测到分层进程，全闪环境以及VS2.6本脚本不适用"
    exit 1
fi

echo "1.备份脚本"
echo "cp /sf/vs/bin/vs_ssd_get_life_info.sh /sf/vs/bin/vs_ssd_get_life_info.sh.bak"
if [ ! -f  /sf/vs/bin/vs_ssd_get_life_info.sh.bak ];then
    cp /sf/vs/bin/vs_ssd_get_life_info.sh /sf/vs/bin/vs_ssd_get_life_info.sh.bak
fi

echo "2.修改脚本"
if [ -f  /sf/vs/bin/vs_ssd_get_life_info.sh.bak ];then
    sed -i /'local key=$2'/a\return\ 0 /sf/vs/bin/vs_ssd_get_life_info.sh 
    sed -i /'local key=$2'/a\echo\ 5  /sf/vs/bin/vs_ssd_get_life_info.sh
fi

echo "3.修改生效"
echo "vs_tier_cli.py -c ssdlife"
vs_tier_cli.py -c ssdlife
echo "gluster vol set $(gluster_orig v list) performance.wcc-enable off"
echo "gluster vol set $(gluster_orig v list) performance.wcc-delay-time 0"
gluster vol set $(gluster_orig v list) performance.wcc-enable off
gluster vol set $(gluster_orig v list) performance.wcc-delay-time 0

echo "4.等待分层回刷完毕"
echo "通过命令 vs_tier_cli.py -c dump |grep -E "dirty_block_cnt\|clean_block_cnt" 观察分层回刷的进程，当dirty_block_cnt和clean_block_cnt都变成0之后，说明回刷完成。"
while [ 1 ];do
    total=$(vs_tier_cli.py -c dump |grep -E "dirty_block_cnt|clean_block_cnt" |sed s/,//g | awk 'BEGIN{sum=0}{sum+=$2}END{print sum}')
    if [ $total -eq 0 ];then
        echo "缓存回刷完成"
        break
    else
        echo "等待回刷"
        sleep 5
    fi
done

echo "5.请拔掉缓存盘，页面替换"

sleep 30

while [ 1 ];do
    read -p "请确认页面是否已经替换完成(如果已替换完成请键入OKOK，未替换完成请等待):" finish_word
    if [ "$finish_word" == "OKOK" ];then
        break
    fi
done


echo "6.恢复"
echo "恢复备份脚本（mv /sf/vs/bin/vs_ssd_get_life_info.sh.bak /sf/vs/bin/vs_ssd_get_life_info.sh）"
mv /sf/vs/bin/vs_ssd_get_life_info.sh.bak /sf/vs/bin/vs_ssd_get_life_info.sh
echo "gluster vol set $(gluster_orig v list) performance.wcc-enable on"
echo "gluster vol reset $(gluster_orig v list) performance.wcc-delay-time"
gluster vol set $(gluster_orig v list) performance.wcc-enable on
gluster vol reset $(gluster_orig v list) performance.wcc-delay-time

echo "vs_tier_cli.py -c ssdlife"
vs_tier_cli.py -c ssdlife 

echo "7.等待分层生效"
echo "通过命令 vs_tier_cli.py -c dump |grep -E "dirty_block_cnt\|clean_block_cnt" 观察分层进程，当dirty_block_cnt和clean_block_cnt都变成非0之后，说明生效完成。"
while [ 1 ];do
    total=$(vs_tier_cli.py -c dump |grep -E "dirty_block_cnt|clean_block_cnt" |sed s/,//g | awk 'BEGIN{sum=0}{sum+=$2}END{print sum}')
    if [ $total -ne 0 ];then
        echo "缓存生效"
        break
    else
        echo "等待生效,如果长时间不生效，请killall -9 tierd强制生效"
        vs_tier_cli.py -c dump |grep -E "dirty_block_cnt|clean_block_cnt"
        sleep 5
    fi
done

echo "8.替换结束"

