#!/bin/bash
# vsts_shard_remove.sh

toolpath="tools/common-tools/vsts_cluster_tool3x.py"

# 卷相对路径, 如 /.vs/trash/my.qcow2
path=$1
if [ "X""$path" == "X" ];then
    echo "Usage: vsts_shard_remove.sh  /.vs/trash/myxxxx.qcow2"
    exit -1
fi

gluster v i > /sf/log/vs/gluster_v_i.log
if [ $? -ne 0 ];then
    echo "获取卷配置失败！"
    exit -1
fi

meta_path="$(grep meta /sf/log/vs/gluster_v_i.log | grep "$(hostname)" | head -n 1 | awk '{print $2}' | awk -F':' '{print $2}')"
if [ "X""$meta_path" == "X" ];then
    echo "本主机没有meta brick，请在以下主机中选择一台主机执行本脚本:"
    grep meta /sf/log/vs/gluster_v_i.log |grep host-|awk -F ':' '{print $2}'|sort -u
    exit -1
fi

if [ ! -f "$meta_path$path" ];then
    echo "只允许删除普通文件！！！"
    exit -1
fi

# route_info=$(getfattr -d -m . -e hex -n trusted.route.info .vs/shard/fd/fd586ad6-891b-4b7c-b4de-e6962ed6c9cd/fd586ad6-891b-4b7c-b4de-e6962ed6c9cd.00347.shard)
route_info=$(getfattr -d -m . -e hex -n trusted.route.info "${meta_path}/${path}" | grep "^trusted.route.info" | awk -F'0x' '{print $2}')
gfid_hex=$(getfattr -d -m . -e hex -n trusted.gfid "${meta_path}/${path}" | grep "^trusted.gfid" | awk -F'0x' '{print $2}')
gfid=${gfid_hex: 0: 8}-${gfid_hex: 8: 4}-${gfid_hex: 12: 4}-${gfid_hex: 16: 4}-${gfid_hex: 20: 12}
echo "${gfid}"
if [ -z "$gfid" ]
then
    echo "解析文件gfid失败"
    exit -1
fi

vsmgr route-tool parse "0x${route_info}"
route=$(vsmgr route-tool parse "0x${route_info}" | awk -F'[' '{print $2}' | awk -F']' '{print $1}' | awk -F',' '{printf "%s %s %s", $1, $2, $3}' | awk  '{printf "%s:%s:%s", $1, $2, $3}' )
[[ "$route" =~ ^[0-9]+\:[0-9]+\:[0-9]+$ ]] || exit

echo $toolpath  -c remove -r "$route" -g "${gfid}"
$toolpath  -c remove -r "$route" -g "${gfid}"
echo /root/vsts_cluster_tool3x.py  -c "remove ${path}"
$toolpath  -c "remove ${path}"
