#!/bin/bash

# vsts_residue_shard_clear.sh
# 本脚本自动清理所有首分片不存在，但子分片还在的残留分片
# 执行前需要将vsts_shard_remove.sh以及vsts_cluster_tool3x.py一并放到/root目录下

all_shard="/sf/log/vs/vst_all_shard.log"
all_badfirstshard="/sf/log/vs/vst_all_badfirstshard.log"
all_badsubshard="/sf/log/vs/vst_all_badsubshard.log"
meta_bakup="/sf/data/local/meta_bakup.txt"

function get_residue_shard() {
    local mbrick="$1"

    # 获取指定meta的所有分片
    find "$mbrick/.vs/shard" -type f > $all_shard
    if [ $? -ne 0 ]; then
      echo "ERROR: dump meta gfids error"
      return 1
    fi

    # 查看首分片硬链接，不存在就保存到/sf/log/vst_all_badfirstshard.log
    truncate -s 0 $all_badfirstshard
    for g in $(cat $all_shard | awk -F/ '{print $11}' | sort -u)
    do
        if [ ! -f "$mbrick/.glusterfs/${g:0:2}/${g:2:2}/$g" ]; then
            echo $g >> $all_badfirstshard
        fi
    done

    # 找出残留分片的所有子分片
    truncate -s 0 $all_badsubshard
    for g in $(cat $all_badfirstshard)
    do
        ls $mbrick/.vs/shard/${g:0:2}/$g/* | sed "s|$mbrick||g" >> $all_badsubshard
    done
}

function remove_residue_shard() {

    if [ ! -e "$meta_bakup" ];then
        touch $meta_bakup
    fi

    for subpath in $(cat $all_badsubshard)
    do
        first_shard=$(echo $subpath|awk -F '/' '{print $5}')
        lookup_ret=$(vs_rpc_tool -c stat -u $first_shard 2>&1 | grep "op_ret" | awk -F "'op_ret': " '{print $2}' | awk -F "," '{print $1}')
        if [ "X""$lookup_ret" == "X""-2" ];then
            # 先备份待清理分片的属性
            date >> $meta_bakup
            /sf/vs/bin/getfattr -m . -d -e hex $meta_path/.vs/shard/${first_shard:0:2}/$first_shard/*  >> $meta_bakup
            if [ $? -ne 0 ];then
                echo "******** 获取待删除子分片: $subpath的属性失败, 需要研发介入处理$all_badsubshard中的后续所有残留分片！！！********"
                exit -1
            fi

            # 删除分片
            modules/shard/vsts_shard_remove.sh $subpath
        else
            echo "********* 分片: $first_shard 在本地meta目录中找不到，但是lookup结果不是-2, 需要研发介入处理$all_badsubshard中的后续所有残留分片！！！*********"
            exit -1
        fi
    done
}

function main() {

    gluster v i > /sf/log/vs/gluster_v_i.log
    if [ $? -ne 0 ];then
        echo "获取卷配置失败！"
        exit -1
    fi

    # 两主机卷不支持
    meta_num="$(grep meta /sf/log/vs/gluster_v_i.log | grep host-|wc -l)"
    if [ $meta_num -lt 3 ];then
        echo "请确保在大于或等于3主机的虚拟存储卷的卷内主机上执行此脚本！"
        exit 0
    fi

    # 获取本主机所有meta brick
    meta_path="$(grep meta /sf/log/vs/gluster_v_i.log | grep "$(hostname)" | head -n 1 | awk '{print $2}' | awk -F':' '{print $2}')"
    if [ "X""$meta_path" == "X" ];then
        echo "本主机没有meta brick，请在以下主机中选择一台主机执行本脚本:"
        grep meta /sf/log/vs/gluster_v_i.log |grep host-|awk -F ':' '{print $2}'|sort -u
        exit -1
    fi

    # 获取所有残留分片
    get_residue_shard $meta_path

    # 如果有残留分片，对残留分片进行二次检查后删除
    if [ ! -e "${all_badfirstshard}" ] || [ -z "$(cat $all_badfirstshard)" ]; then
        echo "不存在残留分片."
        exit 0
    else
        remove_residue_shard
    fi
}

main
