# coding: utf-8
#!/usr/bin/env python
"""
## 左子树残留文件检查和清理工具

### 场景说明

- 左子树删除文件的时候，由于某个副本离线，导致该副本文件未被删除；在删除该文件父目录的时候，此时离线的brick重新上线，
此时，目录会删除报错。后续，被删除的文件会被修复出来。由此，而产生了左子树的垃圾文件，而右子树的数据实际上已经被删除掉了。

### 命令说明

```shell
./vsfire.py meta del_left_tree_shard ${gfid}
# 显示对应gfid左子树文件 并提示是否需要删除
```
"""
import os
import subprocess32 as subprocess
from libvs.utils.vs_get_from_vt import vtp_get_host_info as _get_host_info

_g_gfid_len = 36
_g_ssh_tool = "/sf/vs/bin/vs_ssh"


def _show_help(process_name):
    print("{} <g/gfid> gfid".format(process_name))

def _get_online_hosts():
    online_hosts = []
    hosts_list = _get_host_info()
    for host in hosts_list:
        if host['host_status'] == "on":
            online_hosts.append(host['host_name'])
    return online_hosts


def _file_is_exist(host, file_path, files_list):
    cmd = "[ -f {} ]".format(file_path)
    res = os.system("{} root@{} \'{}\'".format(_g_ssh_tool, host, cmd))
    if res == 0:
        files_list.append(file_path)

    return files_list


def _get_file_path_from_host(host, gfid):
    file_path = ""
    files_list = []
    pos1 = gfid[0:2]
    pos2 = gfid[2:4]

    cmd = "{} root@{} \'ls -d /sf/data/vs/local/*-meta/* | grep -v lost+found\'".format(_g_ssh_tool, host)
    dirs = subprocess.Popen(cmd, stdout=subprocess.PIPE, shell=True)
    for dir in dirs.stdout.readlines():
        dir = dir[:-1]
        file_path = dir + '/.vs/shard/' + pos1 + '/' + gfid
        files_list = _file_is_exist(host, file_path, files_list)

        file_path = dir + '/.vs/shard/' + pos1 + '/deleted/' + gfid
        files_list = _file_is_exist(host, file_path, files_list)

        file_path = dir + '/vs/snapshot/' + pos1 + gfid
        files_list = _file_is_exist(host, file_path, files_list)

        file_path = dir + '/.glusterfs/' + pos1 + '/' + pos2 + '/' + gfid
        files_list = _file_is_exist(host, file_path, files_list)

    cmd = "{} root@{} \'ls -d /sf/data/vs/local/*/* | grep -v lost+found\'".format(_g_ssh_tool, host)
    dirs = subprocess.Popen(cmd, stdout=subprocess.PIPE, shell=True)
    for dir in dirs.stdout.readlines():
        dir = dir[:-1]
        file_path = '{}/{}'.format(dir, gfid)
        files_list = _file_is_exist(host, file_path, files_list)

        file_path = '{}/.glusterfs/{}/{}/{}'.format(dir, pos1, pos2, gfid)
        files_list = _file_is_exist(host, file_path, files_list)

    return files_list


def _get_files_path(gfid):
    host_file_dict = {}
    if len(gfid) != _g_gfid_len:
        return False

    hosts_list = _get_online_hosts()

    for host in hosts_list:
        files = _get_file_path_from_host(host, gfid)
        host_file_dict[host] = files

    return host_file_dict


def _display_files(host_files):
    for host, files in host_files.items():
        print("{}:".format(host))
        for file in files:
            print("{}".format(file))
        if files:
            print("-"*50)


def _delete_files(host_files):
    """delete meta data"""
    for host, files in host_files.items():
        for file in files:
            if file.find('meta') != -1:
                print("meta: {}".format(file))
                res = os.system("{} root@{} rm -f {}".format(_g_ssh_tool, host, file))
                if res != 0:
                    print("delete failed: {}".format(file))

    for host, files in host_files.items():
        for file in files:
            if file.find('meta') == -1:
                print("{}".format(file))
                res = os.system("{} root@{} rm -f {}".format(_g_ssh_tool, host, file))
                if res != 0:
                    print("delete failed: {}".format(file))



