# coding: utf-8
#!/usr/bin/env python
"""
## 残留分片检查和清理工具

### 场景说明

- 左子树删除文件的时候，由于某个副本离线，导致该副本文件未被删除；在删除该文件父目录的时候，此时离线的brick重新上线，
此时，目录会删除报错。后续，被删除的文件会被修复出来。由此，而产生了左子树的垃圾文件，而右子树的数据实际上已经被删除掉了。

### 命令说明

```shell
./vsfire.py meta del_left_tree_shard ${gfid}
# 显示对应gfid左子树文件 并提示是否需要删除
```
"""
import sys
import os
import subprocess
import shard_clear as _shard_clear
import shard_faultshow
import pylib.utils.utiltools as common
import modules.shard.disklba2file.vsts_disk_lba2file as _lba2file


_subshard_clear_tool="shard_residue_clear.sh"
_doublefault_show_tool="double_fault_show.sh"

@common.only_support_3x
def shard_clear(gfid=''):
    """
    删除左子树/子分片残留 的分片
    """
    if gfid == '':
        script_path = os.path.join(os.path.dirname(__file__), _subshard_clear_tool)
        process = subprocess.Popen(script_path, shell=True, stdout=sys.stdout, stderr=sys.stderr)
        process.communicate()

        returncode = process.returncode

        if returncode == 0:
            print("Shell 脚本执行成功")
        else:
            print("Shell 脚本执行失败")
        return returncode 

    host_files = _shard_clear._get_files_path(gfid)
    gfid = str(gfid)
    if host_files == False:
        print("Invalid gfid: {}".format(gfid))
        return

    shard_clear._display_files(host_files)

    result = raw_input('\nAre you sure to delete above files? [yes/no]: ')
    if result.lower() == 'yes':
        # print(host_files)
        shard_clear._delete_files(host_files)
    elif result.lower() == 'no':
        print("exit !!!")
    else:
        print("invaild input")

    return


@common.only_support_3x
def faultshow_bricks(breakdown_disks, scan_allbricks=False):
    """
    显示故障盘中分片受损情况
    """
    shard_faultshow.faultshow(breakdown_disks, None, scan_allbricks)


@common.only_support_3x
def faultshow_host(breakdown_host, scan_allbricks=False):
    """
    显示故障主机的所有分片受损情况
    """
    shard_faultshow.faultshow(None, breakdown_host, scan_allbricks)

@common.only_support_3x
def faultshow_doublefailure():
    """
    整理所有双点分片对应的文件名
    """
    script_path = os.path.join(os.path.dirname(__file__), _doublefault_show_tool)
    process = subprocess.Popen(script_path, shell=True, stdout=sys.stdout, stderr=sys.stderr)
    process.communicate()

    returncode = process.returncode

    if returncode == 0:
        print("Shell 脚本执行成功")
    else:
        print("Shell 脚本执行失败")
    return

@common.only_support_3x
def lba2file(disk, mountpoint, address):
    """
    根据裸盘的lba获取对应的文件 
    """
    return _lba2file.addr2file(disk, mountpoint, address)


