#!/bin/bash

log_path='log/doublefailure'

vsts_gfid2path_work=/sf/vs/bin/vsts_gfid2path.py
if [ ! -e $vsts_gfid2path_work ]; then
echo "#!/sf/vs/bin/python
# -*- coding:utf-8 -*-
# vsts_gfid2path.py
# 找分片所在的用户文件
from __future__ import print_function
import sys
import argparse
from shard import ShardService
from fnmatch import fnmatch

shard_service = ShardService.ShardService()

def arg_parse():
    parser = argparse.ArgumentParser(description='找分片所在的用户文件.')
    parser.add_argument('gfid', type=str, help='要查找的gfid列表')
    args = parser.parse_args()
    return args

def path_is_shard(path):
    return fnmatch(path, '/.vs/shard/*')

def path_is_snap(path):
    return fnmatch(path, '/vs/snapshot/*')

def gfid2basegfid(gfid):
    srv_gfid2bgfid = shard_service.gfid2basegfid([gfid])[0]
    return srv_gfid2bgfid.bgfid

def gfid2path(gfid):
    srv_gfid2path = shard_service.gfid2path([gfid])[0]
    return srv_gfid2path.path

def snap2bpath(snap):
    return gfid2path(snap.split('/')[4])

def do_gfid2_path(gfid):
    bgfid = gfid2basegfid(gfid)
    path = gfid2path(bgfid)
    if path_is_snap(path):
        path = snap2bpath(path)
    return path

def main():
    args = arg_parse()
    gfids = args.gfid
    gfids = gfids.split(',')
    for gfid in gfids:
        path = do_gfid2_path(gfid)
        print(gfid, path)

if __name__ == \"__main__\":
    sys.exit(main())

" > $vsts_gfid2path_work

chmod +x $vsts_gfid2path_work
fi

filename="gfid.log"


function main()
{
    if [ ! -d $log_path ];then
        mkdir $log_path
    fi

    #echo "Call script($0 $@) start.
    ops_exec_command
    if [ $? -ne 0 ]; then
        if [ $? -eq $EINVAL ]; then
            usage
            return 1
        fi

    fi
    echo ""
    echo "相关结果请在 $log_path中查看"
}

function is_number() {
  # 使用正则表达式匹配数字模式
  if [[ $1 =~ ^[0-9]+$ ]]; then
    return 0
  fi
  return 1
}

function find_uuid() {
    vg_uuid=$(grep "$g_dev|uuid" -rn /sf/cfg/vs/disk/ |grep uuid |awk -F ':' '{print $2}'|awk -F '"' '{print $2}')
    echo $vg_uuid
    brickno=$(gluster v i |grep $vg_uuid |head -n 1 |awk -F 'Brick' '{print $2}' |awk -F ':' '{print $1}')
    echo $brickno
    vs_rpc_tool -c list --brickno $brickno > $log_path/$1.log
    cat $log_path/$1.log |awk -F '|' '{print $2}' >$log_path/tmp_gfid.log
    cat $log_path/tmp_gfid.log |grep "-" >$log_path/$filename
}

function ops_exec_command() {
    echo '' >$log_path/$filename

    vs_rpc_tool -c lookup > $log_path/err_lookup.log
    cat $log_path/err_lookup.log | grep -o -E '[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}' >$log_path/$filename
    echo ''>$log_path/evslun.log
    echo ''>$log_path/vmlist_name.log

    # 逐行读取文件
    while IFS= read -r line
    do
      if [[ -z $line ]];then
        continue
      fi
      res=$(vsts_gfid2path.py $line | awk -F ' ' '{print $2}')
      #echo $res
      # 判断$line是否包含vslun
      if [[ $res == *"vslun"* ]]; then
          echo $res >> $log_path/evslun.log
      elif [[ $res == *"/images/cluster/"*"vm-disk-"*".qcow2"* ]]; then
           #/images/cluster/e20f2bea744a/5739323109737.vm/vm-disk-1.qcow2
           # 这里输出一个受到影响的虚拟机的磁盘文件
            echo $res >> $log_path/bad_qcow2_list.log.tmp
            vmID=$(echo $res | awk -F '.vm' '{print $1}' | awk -F '/' '{print $(NF)}' | sort -u)
            vmname=$(grep $vmID -r /cfs/.vmlist |awk -F 'vm_name' '{print $2}'|awk -F '"' '{print $3}')
            diskDetail=$(echo $res | awk -F '/' '{print $(NF)}' | sort -u)
            echo "vm_name:$vmname:detail:$diskDetail">>$log_path/vmlist_name.log
            #grep $vmID -r /cfs/.vmlist |awk -F 'vm_name' '{print $2}'|awk -F '"' '{print $3}' >>$log_path/vmlist_name.log
      fi
    done < "$log_path/$filename"

    echo "过滤虚拟机列表......"
    cat $log_path/vmlist_name.log |sort -u  > $log_path/vmlist.log
    #cat bad_qcow2_list.log.tmp |sort -u > bad_qcow2_list.log
    #echo "请在bad_qcow2_list.log确认哪些虚拟机的磁盘受到影响。"
    echo -e "请在vmlist.log确认受到影响的虚拟机"

    echo "过滤vslun......"
    cat $log_path/evslun.log |sort -u > $log_path/vslun.log
     echo -e "请在vslun.log确认受到影响的lun"
    # 逐行读取文件
    while IFS= read -r line
    do
      res=$(echo $line | awk -F '/' '{print $3}')
      if [[ -n $res ]];then
        grep -C10 $res -rn /sf/cfg/vs/tgt/target/|grep 'name' | awk -F '"' '{print $4}' > $log_path/lun.log
      fi
    done < $log_path/vslun.log
}

main $@
