#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## vsfire资源清理工具
"""

import os
import pylib.utils.utiltools as common


def vsfire_delete_files_and_dir(vsfire_dir):
    if not os.path.exists(vsfire_dir) or not os.path.isdir(vsfire_dir):
        return

    items = os.listdir(vsfire_dir)
    for item in items:
        item_path = os.path.join(vsfire_dir, item)
        if os.path.isfile(item_path):
            common.logger.info('try to remove file: {}'.format(item_path))
            os.remove(item_path)

    # 再判断一次目录，如果为空，删除目录
    items = os.listdir(vsfire_dir)
    if not items:
        common.logger.info('try to remove vsfire_dir: {}'.format(vsfire_dir))
        os.rmdir(vsfire_dir)


def vsfire_resource_clean():
    version = common.get_vs_version()
    if not common.is_vs_version_valid(version):
        return -1

    common.logger.info('try to vsfire_resource_clean')

    readline = 'vsfire工具是否执行完成（建议执行完所有操作后，最终统一执行临时资源清理），输入\'y\'继续，\'n\'退出'
    common.check_terminal_input(readline)

    volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
    if not volume_name:
        common.logger.error('failed to supported, cannot find volume name')
        return -1

    # 清理EFS挂载点
    if common.vs_has_efs(version, hosts):
        for host in hosts:
            brick = {'host': host}
            common.umount_efs_path(brick)

    # 清理vsfire_recovery_FEC61AC2目录
    vsfire_dir = os.path.join(common.get_vs_mount_path(volume_name, version), common.vsfire_recovery_dir)
    vsfire_shard_backup_dir = os.path.join(vsfire_dir, 'shard_backup')
    vsfire_file_backup_dir = os.path.join(vsfire_dir, 'file_backup')

    if os.path.exists(vsfire_dir):
        readline = '请确认是否可以删除目录: {}，该目录用于存在vsfire备份的数据，输入\'y\'继续，\'n\'退出'.format(vsfire_dir)
        common.check_terminal_input(readline)

        vsfire_delete_files_and_dir(vsfire_shard_backup_dir)
        vsfire_delete_files_and_dir(vsfire_file_backup_dir)
        vsfire_delete_files_and_dir(vsfire_dir)

    return 0


def _vsfire_resource_clean():
    lock_file = common.get_vsfire_lock_file()
    with common.VsfireFlock(lock_file) as lock:
        ret = vsfire_resource_clean()
        if ret:
            print common.Colored().red('执行失败')
        else:
            print common.Colored().cyan('执行成功')
        return ret
