#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 资源清理工具
"""
from modules.resource_clean.resource_clean import _tier_file_clean
from modules.resource_clean.vsfire_clean import _vsfire_resource_clean
from modules.resource_clean.fix_images_lock import _check_vm_and_handle_lock
from modules.resource_clean.file_clean import _file_clean
from modules.resource_clean.changelog_clean import _changelog_clean


def vsfire_resource_clean():
    """
    vsfire工具执行过程中，如果有异常，可能会导致文件残留，使用本方法，清理所有的vsfire工具残留
    （建议使用vsfire工具后，执行本方法，防止出现临时资源残留）

    """
    _vsfire_resource_clean()


def tier_file_clean(brick_path, gfid):
    """
    分层残留文件清理（适用于vs2.6/vs2.8版本，由于底层副本残留了，导致分层内文件残留）

    基本原理：确认远端副本是否存在，如果不存在，直接把当前副本删除，如果存在，把当前副本link创建出来
    输入：
        brick_path: 副本挂载点路径
        gfid: 文件的gfid

    """
    _tier_file_clean(brick_path, gfid)


def images_lock_clean(vmid):
    """
    解决虚拟机启动失败报错[虚拟机镜像忙,正在执行其他操作]的问题，使用版本vs2.8-vs3.6

    基本原理：检查到集群主机上存储客户端残留了虚拟机镜像锁，重启存储客户端，删除残留的虚拟机镜像锁
    输入：
        vmid：虚拟机ID
    """
    _check_vm_and_handle_lock(vmid)

def file_clean(filename):
    """
    文件清理

    基本原理：找出文件所有分片，依次删除每个副本，先删除右子树再删除左子树(适用于vs2.6/vs2.8/3.x版本)
    输入:
        filename: 文件路径 (/images/cluster/test.vm/vm-disk-1.qcow2)
                  文件的gfid (a33c316e-b5eb-44f3-8752-19c6dd1630e6)
    """
    _file_clean(filename)

def changelog_clean():
    """
    changelog清理

    基本原理：本主机本地挂载点下，所有文件与目录, 删除无效的changelog(适用于vs2.6/vs2.8)

    """
    _changelog_clean()