#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 文件清理工具
"""

import os
import pylib.utils.utiltools as common

def get_brick_by_rt(rt_id, replicate):
    for brick in replicate[common.RIGHT_TREE_INDEX]:
        if brick.get('id') == rt_id:
            return brick
    return {}


# 执行单个分片的删除操作（先删除右子树，再删除左子树）
def file_shard_clean(file_shard, replicate):
    gfid = file_shard['gfid']
    route = file_shard['route']
    shard_path = file_shard['path']

    # 先删除右子树
    rts = route.get('rt')
    if not rts:
        common.logger.warn('failed to get rts, gfid: {}'.format(gfid))
        return
    
    has_efs = True if len(rts) >= 3 else False
    for rt_id in rts:
        try:
            brick = get_brick_by_rt(rt_id, replicate)
            if not brick:
                common.logger.warn('failed to get brick id: {}'.format(rt_id))
                continue

            if has_efs and not brick.get('arbiter'):
                # 数据brick, 删除文件
                common.vs_remove_file_3x(brick['host'], brick['path'], gfid)
            else:
                # 仲裁brick
                common.vs_remove_file_2x(brick['host'], brick['path'], gfid, gfid)
            
            common.logger.info('data_brick success to remove host: {}, brick_path: {}, gfid: {}'.
                               format(brick['host'], brick['path'], gfid))
        except common.CmdError as e:
            if not 'No such file or directory' in str(e):
                raise
    
    # 再删除左子树
    for brick in replicate[common.LEFT_TREE_INDEX]:
        try:
            common.vs_remove_file_2x(brick['host'], brick['path'], shard_path, gfid)
            common.logger.info('meta_brick success to remove host: {}, brick_path: {}, gfid: {}'.
                    format(brick['host'], brick['path'], gfid))
        except common.CmdError as e:
            if not 'No such file or directory' in str(e):
                raise

# 对存储内部文件，执行清理，删除所有的分片
def internal_file_clean3x(file_path, replicate, online_bricks):
    common.logger.info('try to clean file: {}'.format(file_path))

    first_shard = {}

    # 依次删除所有分片（除首分片外）的右子树与左子树
    for brick in replicate[common.LEFT_TREE_INDEX]:
        if online_bricks.get(brick['path']) == 'y':
            file_shards = common.get_file_shards_by_meta_brick(brick['host'], brick['path'], file_path)
            if not file_shards:
                # 没有找到分片列表，尝试从下一个元数据brick里面找
                continue
            
            for file_shard in file_shards:
                if file_shard['shard_idx'] == 0:
                    # 保存首分片
                    if not first_shard:
                        first_shard = file_shard
                    continue
                file_shard_clean(file_shard, replicate)

    # 最后删除首分片的右子树与左子树
    if first_shard:
        file_shard_clean(first_shard, replicate)

    print common.Colored().cyan('删除文件: {} 成功'.format(file_path))
    return 0


def get_snapshot_files_by_meta_brick(host, brick_path, first_gfid):
    snapshot_files = []
    try:
        local_snapshot_dir = os.path.join(brick_path, 'vs/snapshot', first_gfid[0:2], first_gfid)
        cmdline = '/usr/bin/find {} -type f'.format(local_snapshot_dir)
        result = common.remote_cli(host, cmdline, True)
        for line in result:
            if line.startswith(brick_path):
                snapshot_file = line.replace(brick_path, '')
                snapshot_files.append(snapshot_file)
    except common.CmdError as e:
        if not 'No such file or directory' in str(e):
            raise
    return snapshot_files

def replicate_file_clean2x(file_path, hosts, replicate):
    from modules.file_recovery.show_fault_files import get_file_replicate_2x
    recovery_replicate = get_file_replicate_2x(file_path, hosts, replicate, True)
    # 获取的数据复制组，可能有多个
    if not recovery_replicate:
        common.logger.error('failed to find data replicate: {}'.format(recovery_replicate))
        return -1
    
    landfill_name = common.calculate_str_md5(file_path)
    for rep_id, replicate_bricks in recovery_replicate.items():
        for brick in replicate_bricks:
            try:
                common.vs_remove_file_2x(brick['host'], brick['path'], file_path, landfill_name)
                common.logger.info('success to remove rep_id: {}, host: {}, brick_path: {}, landfill_name: {}'.format(
                    rep_id, brick['host'], brick['path'], landfill_name))
            except common.CmdError as e:
                if not 'No such file or directory' in str(e):
                    raise
    return 0
        

def replicate_file_clean3x(file_path, replicate, hosts, online_bricks):
    from modules.file_recovery.show_fault_files import get_file_replicate_3x
    recovery_replicate = get_file_replicate_3x(file_path, replicate, online_bricks)
    # 获取的数据复制组，只能是一个
    if not recovery_replicate or len(recovery_replicate) != 1:
        common.logger.error('failed to find data replicate: {}'.format(recovery_replicate))
        return -1
    
    first_gfid, replicate_bricks = next(iter(recovery_replicate.items()))

    # 3主机以上才需要判断快照
    if first_gfid and replicate_bricks and not common.vs_is_two_host(hosts):
        # 判断是否存在快照文件, 如果存在快照文件，则需要清理快照文件
        for brick in replicate[common.LEFT_TREE_INDEX]:
            if online_bricks.get(brick['path']) == 'y':
                snapshot_files = get_snapshot_files_by_meta_brick(brick['host'], brick['path'], first_gfid)
                if not snapshot_files:
                    # 如果没有找到快照文件，需要找所有元数据副本
                    continue
                for snapshot_file in snapshot_files:
                    snapshot_file = snapshot_file[1:] # 去掉开头的'/'
                    internal_file_clean3x(snapshot_file, replicate, online_bricks)

    # 清理base文件
    internal_file_clean3x(file_path, replicate, online_bricks)
    return 0

def file_clean(filename):
    # 如果输入是GFID，转化成
    if common.check_str_is_gfid(filename):
        filename = '/.glusterfs/{}/{}/{}'.format(filename[0:2], filename[2:4], filename)
    
    if not filename.startswith('/'):
        common.logger.error('failed to supported, filename: {}'.format(filename))
        return -1

    version = common.get_vs_version()
    if not common.is_vs_version_valid(version):
        return -1
    
    volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
    if not volume_name:
        common.logger.error('failed to supported, volume_name: {}'.format(volume_name))
        return -1

    online_bricks = common.get_online_bricks(volume_name)
    if common.fault_point_result() or not online_bricks:
        # 至少有一个在线brick
        common.logger.error('failed to supported, cannot find online_bricks')
        return -1

    file_path = filename[1:]

    readline = '请确认是否执行删除文件: {}，输入\'y\'确认删除，\'n\'取消退出'.format(filename)
    common.check_terminal_input(readline)

    result = 0
    if version >= common.VS_VERSION_3_0:
        result = replicate_file_clean3x(file_path, replicate, hosts, online_bricks)
    else:
        result = replicate_file_clean2x(file_path, hosts, replicate)
    return result


def _file_clean(filename):
    lock_file = common.get_vsfire_lock_file()
    with common.VsfireFlock(lock_file) as lock:
        ret = file_clean(filename)
        if ret:
            print common.Colored().red('执行失败')
        else:
            print common.Colored().cyan('执行成功')
        return ret
