#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## changelog清理工具
"""

import os
import re
import socket
import pylib.utils.utiltools as common

# 从复制组中，找到当前主机是否在其中，如果是返回复制组的brick id列表
def get_replicate_brick_ids(localhost, bricks_replicate):
    brick_ids = []
    localhost_brick = {}
    for brick in bricks_replicate:
        if brick['host'] == localhost:
            localhost_brick = brick
        brick_ids.append(brick['id'])

    return localhost_brick, brick_ids

def file_changelog_clean(root, file, brick_ids):
    cmdline = '{} -d -m. -e hex "{}"'.format(common.s_getfattr_bin, os.path.join(root, file))
    # common.logger.info('try to cmdline: {}'.format(cmdline))
    result = common.cli(cmdline, True)
    for xattr in result:
        if re.search(r"vs_vol_rep2-client-", xattr):
            xattr_key = xattr.split('=')[0]
            client_id = int(xattr_key.split('-')[-1])
            if client_id+1 not in brick_ids:
                cmdline = '{} -x {} "{}"'.format(common.s_setfattr_bin, xattr_key, os.path.join(root, file))
                common.logger.info('try to cmdline: {}'.format(cmdline))
                common.cli(cmdline, False)

def brick_changelog_clean(localhost_brick, brick_ids):
    brick_path = localhost_brick['path']
    if not os.path.exists(brick_path):
        common.logger.warn('brick_path: {} is not exists'.format(brick_path))
        return
    common.logger.info('brick: {}, try to clean invalid xattr'.format(brick_path))
    exclude_dirs = ['.glusterfs']
    
    # 先对根目录执行
    file_changelog_clean(brick_path, '', brick_ids)
    
    # 再遍历目录下的所有的子目录与子文件执行
    for root, dirs, files in os.walk(brick_path):
        dirs[:] = [d for d in dirs if d not in exclude_dirs]            
        for dir in dirs:
            file_changelog_clean(root, dir, brick_ids)

        for file in files:
            file_changelog_clean(root, file, brick_ids)


def changelog_clean():
    version = common.get_vs_version()
    if not common.is_vs_version_valid(version):
        return -1
    
    if version >= common.VS_VERSION_3_0:
        common.logger.error('failed to supported, only support vs version < 3.0')
        return -1
    
    volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
    if not volume_name:
        common.logger.error('failed to supported, volume_name: {}'.format(volume_name))
        return -1

    readline = '请确认是否执行删除本地挂载点下所有文件与目录的无效changelog, 输入\'y\'确认删除，\'n\'取消退出'
    common.check_terminal_input(readline)

    localhost = socket.gethostname()
    assert localhost

    for rep_id, bricks in replicate.items():
        localhost_brick, brick_ids = get_replicate_brick_ids(localhost, bricks)
        if not localhost_brick or not brick_ids:
            continue
        
        brick_changelog_clean(localhost_brick, brick_ids)

    return 0


def _changelog_clean():
    lock_file = common.get_vsfire_lock_file()
    with common.VsfireFlock(lock_file) as lock:
        ret = changelog_clean()
        if ret:
            print common.Colored().red('执行失败')
        else:
            print common.Colored().cyan('执行成功')
        return ret
