#!/sf/vs/bin/python
# -*- coding: utf-8 -*-
import re
import subprocess
import os
import sys
import logging
import pylib.utils.utiltools as common


reload(sys)
sys.setdefaultencoding('utf8')
logger = logging.getLogger(__name__)

sys.path.append('/sf/vs/bin/')



class MigrateError(Exception):
    pass


def get_cluster_info():
    cmdline = "/sf/vs/glusterfs/sbin/gluster vol info"
    lines = common.cli(cmdline, True)
    volumes = []
    vgs={}
    for line in lines:
        if line == 'No volumes present':
            continue
        if re.search(r"host-\w{12}:", line):
            host = line.split(':')[1].strip()
            vg = line.split(':')[2].strip().split('/')[5]

            if vg not in vgs:
                vgs[vg] = host
    df_cmd = "df"
    mounts = common.cli(df_cmd, True)
    for mount_info in mounts:
        volume_name = re.findall(r"/sf/data/vs/gfs/(rep\d)", mount_info) + re.findall(r"/sf/data/vs/gfs/(.+?rep\d)", mount_info)
        if volume_name:
            volumes = volume_name
            break

    return volumes, vgs

def get_vm_stat():
    vms_stat = {}
    if os.path.exists('/cfs/nodes/cluster/vmpower.info'):
        cmd = 'cat /cfs/nodes/cluster/vmpower.info'
        lines = common.cli(cmd, True)
        for line in lines:
            if not line:
                continue
            vm_stat = line.split(",")[0].split("=")
            vms_stat[vm_stat[0]] = vm_stat[1]
    else:
        cmd = '/sf/bin/qm-c list'
        lines = common.cli(cmd, True)
        for line in lines:
            if ("VMID" in line and "NAME" in line and "STATUS" in line and "PID" in line) or not line:
                continue
            else:
                vmid = line.split()[0]
                if "stopped" in line:
                    vms_stat[vmid] = 'off'
                else:
                    vms_stat[vmid] = 'on'
         
    return vms_stat
	
def str_to_float(s):
    """
    将字符串转化为浮点数，以M为单位
    :param s: 输入字符串
    :return: 输出以M为单位的浮点数
    """
    result = 0.0
    s = s.lower()
    if s.endswith('t'):
        result = float(s[:-1])
        result *= (1024 * 1024)
    elif s.endswith('g'):
        result = float(s[:-1])
        result *= (1024)
    elif s.endswith('m'):
        result = float(s[:-1])
    elif s.endswith('k'):
        result = float(s[:-1]) / (1024)
    elif s.endswith('b'):
        result = float(s[:-1]) / (1024 * 1024)
    else:
        raise MigrateError("str to float error")

    return result
	

def get_vg_info(current_host, hosts):
    # 分析出主机，Brick列表及容量情况
    cmdline = "/sbin/vgs --units m"
    vgs = {}
    for host in hosts:
        if host == current_host:
            lines = common.cli(cmdline, True)
            for line in lines:
                m_vg = re.search(r"\w{6}-\w{4}-\w{4}-\w{4}-\w{4}-\w{4}-\w{6}", line)
                if m_vg:
                    vg = line.split()
                    if host not in vgs:
                        vgs[host] = {}
                    vgs[host][vg[0]] =  str_to_float(vg[6]) /  str_to_float(vg[5])
        else:
            lines = common.remote_cli(host, cmdline)
            for line in lines.splitlines():
                m_vg = re.search(r"\w{6}-\w{4}-\w{4}-\w{4}-\w{4}-\w{4}-\w{6}", line)
                if m_vg:
                    vg = line.split()
                    if host not in vgs:
                        vgs[host] = {}
                    vgs[host][vg[0]] =  str_to_float(vg[6]) / str_to_float(vg[5])

    return vgs

def get_dump_gluster_vgs():
    def encap_vg_and_hostname(hosts, list_data_vgs, vg_uuid_one, vg_uuid_two):
        vg_info_one = vg_uuid_one.split(':')[1].split('(')[0]
        vg_info_two = vg_uuid_two.split(':')[1].split('(')[0]
        host_name_one = vg_uuid_one.split(':')[0]
        host_name_two = vg_uuid_two.split(':')[0]
        vg_one = vg_info_one.split('/')[5]
        vg_two = vg_info_two.split('/')[5]
        if host_name_one not in hosts:
            hosts.append(host_name_one)
        if host_name_two not in hosts:
            hosts.append(host_name_two)
        vg_key = vg_one + "--" + vg_two
        if vg_key not in list_data_vgs:
            list_data_vgs[vg_key] = {
                vg_one: host_name_one,
                vg_two: host_name_two
            }
    list_data_vgs = {}
    hosts = []
    try:
        gluster_vg_cmd = "gluster v i | grep 'Brick[0-9][0-9]*' | grep -v 'VG:' | awk '{print $2$3}'"
        gluster_vgs = subprocess.check_output(gluster_vg_cmd, shell=True)
    except Exception as ex:
        logger.error("get gluster disks info failed. reason {}".format(ex))
        return ""
    isArbiter = 'arbiter' in gluster_vgs
    gluster_vgs = gluster_vgs.strip().split('\n')
    list_len = len(gluster_vgs)
    for vg in gluster_vgs:
        i = gluster_vgs.index(vg)
        if i + 1 == list_len:
            break
        if not isArbiter:
            if i % 2 == 0:
                encap_vg_and_hostname(hosts, list_data_vgs, vg, gluster_vgs[i + 1])
            else:
                encap_vg_and_hostname(hosts, list_data_vgs, gluster_vgs[i - 1], vg)
        elif 'arbiter' in vg:
            encap_vg_and_hostname(hosts, list_data_vgs, gluster_vgs[i - 2], gluster_vgs[i - 1])
            logger.info("disks uuid: {} , {}".format(gluster_vgs[i - 1], gluster_vgs[i - 2]))
        else:
            if 'arbiter' in gluster_vgs[i + 1]:
                encap_vg_and_hostname(hosts, list_data_vgs, gluster_vgs[i - 1], vg)
                logger.info("is arbiter, disk_uuid: {}, vg:{}".format(gluster_vgs[i + 1], gluster_vgs[i - 1]))
            else:
                encap_vg_and_hostname(hosts, list_data_vgs, vg, gluster_vgs[i + 1])
                logger.info("no arbiter, disk_uuid: {}, {}".format(vg, gluster_vgs[i + 1]))
    return hosts, list_data_vgs



