#!/sf/vs/bin/python
# -*- coding: utf-8 -*-

"""
## 2.x版本平衡工具
"""

import os
import json
import sys
import socket
import logging
import rebalance_lib
import pylib.utils.utiltools as common

reload(sys)
sys.setdefaultencoding('utf8')
logger = logging.getLogger(__name__)

sys.path.append('/sf/vs/bin/')


@common.only_support_2x
def check_file(vg, volume_id, inter_call="no"):
    """
    检查指定VG的容量使用情况
    """
    (volumes, vgs) = rebalance_lib.get_cluster_info()
    print "volume list :{}".format(volumes)

    try:
        if vg not in vgs and  volume_id not in volumes:
            raise rebalance_lib.MigrateError("vg: {0} or volume_id: {1} is error, volumes:{2} please retry input ".format(vg, volume_id, volumes))
        
        host = vgs.get(vg)
        if None == host:
             raise rebalance_lib.MigrateError("请确认输入的vg: {} 是否在卷中！！".format(vg)) 

        vms_stat = rebalance_lib.get_vm_stat()
        cmd = 'for myfile in $(for file in $(find /sf/data/vs/local/{}/*/ -name *.qcow2 -type f );do ls -algh $file ;done| grep -v "T " | cut -d "/" -f 8-20);do filepath=/sf/data/vs/gfs/{}/$myfile; vmid=$(basename "$(dirname $filepath)"/*.conf | grep -Eo [0-9]+); file_size=$(ls -l --block-size=K  $filepath |cut -d  " " -f 5);echo $vmid, $filepath, $file_size ;done 2>/dev/null'.format(vg, volume_id)
        vms_info = {"on": [], "off":[], "None":[]}
        result = common.remote_cli(host, cmd)
        data_check = '/sf/vs/bin/vs_quick_lookup.sh {}'
 
        vm_list = result.splitlines()
        for vm in vm_list:
            data_list = vm.split(',')

            vmpath = data_list[1]
            data_info = common.cli(data_check.format(vmpath))
            data_str = "".join(data_info)
            if vg not in data_str:
                continue

            disk_size = data_list[2].strip()
            real_size = float(data_list[2].strip()[:-1])

            vmid = data_list[0]
            if vmid in vms_stat:
                vm_stat = vms_stat[vmid]
            else:
                vm_stat = 'on' ##没查找到认为运行中

            if 'images/cluster' not in data_list[1]:
                vmid = 'None'
                vm_stat = 'None'

            vm_info = {"vmid": vmid, "disk_size": disk_size, "real_size": real_size, "vmpath": vmpath, "vm_stat": vm_stat}
            vms_info[vm_stat].append(vm_info)

        if inter_call != 'yes': 
            print "下面是VG :{} 的qocw2文件使用情况".format(vg)
        for stat, vms in vms_info.items():
            new_vms = sorted(vms, key=lambda x: x['real_size'], reverse=True)
            if inter_call == 'yes':
                vms_info[stat] = new_vms
                continue
            print "\n\nstatus is :{} in vms list:".format(stat)
            for v in new_vms:
                v.pop("real_size")
                print json.dumps(v, encoding='UTF-8', ensure_ascii=False)

        if inter_call == 'yes':
            return vms_info
			
    except Exception as e:
        print '{0:}'.format(str(e))


@common.only_support_2x
def rebalance_file(filepath, volume_id):
    """
    指定文件进行平衡
    """
    (volumes, vgs) = rebalance_lib.get_cluster_info()
    print "volume list :{}".format(volumes)

    try:
        if os.path.exists(filepath): 
            object_file = filepath
        else:
            object_file = "/sf/data/vs/gfs/{}/{}".format(volume_id, filepath)
            if not os.path.exists(object_file):
                raise rebalance_lib.MigrateError("filepath: {0} is not exists, please retry input ".format(filepath))
			  
        if volume_id not in volumes:
            raise rebalance_lib.MigrateError("volume_id: {0} is error, please retry  input ".format(volume_id))
        object_file_bak = '{}.bak'.format(object_file)
        if os.path.exists(object_file_bak):
            print 'object_file:{0:} had reblanced,do not repeat'.format(object_file)
            return
        get_dir = 'dirname {}'.format(object_file)
        dirname = common.cli(get_dir, True)
        if 'images/cluster' in dirname:
            vmid_cmd = 'basename {}/*.conf | grep -Eo [0-9]+'.format(dirname)
            vmid = common.cli(vmid_cmd, True).split()[0]
            vms_stat = rebalance_lib.get_vm_stat()
            if vmid not in vms_stat or vms_stat[vmid] == 'on':
                raise rebalance_lib.MigrateError("filepath:{}, vmid:{} is on, Operation not permitted".format(filepath, vmid))

        mv_cmd = "mv {} {}".format(object_file, object_file_bak)
        print mv_cmd
        common.cli(mv_cmd)
        cp_cmd = "cp {} {}.new".format(object_file_bak, object_file)
        print cp_cmd
        common.cli(cp_cmd)
        re_mv = "mv {}.new {}".format(object_file, object_file)
        print re_mv 
        common.cli(re_mv)
        print 'reblance file success, Please power on and check if the file is virtual machine; old_file:{}'.format(object_file_bak)
    except rebalance_lib.MigrateError as e:
        print '{0:}'.format(str(e))
    except Exception as e:
        if not os.path.exists(object_file) and os.path.exists(object_file_bak):
            cmd = "mv {} {}".format(object_file_bak, object_file)
            print cmd
            common.cli(cmd)
        else:
            print '此时需要问题上升' 
        print '{0:}'.format(str(e))
        pass


@common.only_support_2x
def check_vgs(op_type):
    """
    检查卷内所有VG的使用情况 
    """
    cp_list_data = {}
    vg_15_list = {}
    vg_70_list ={}

    hosts, list_data_vgs = rebalance_lib.get_dump_gluster_vgs()
    current_host = socket.gethostname()
    print list_data_vgs
    vgs_info = rebalance_lib.get_vg_info(current_host, hosts)
    for vg_key, data_vgs in list_data_vgs.items():
        vg_list =  vg_key.split('--')
        vg = vg_list[0] if vgs_info[data_vgs[vg_list[0]]][vg_list[0]] > vgs_info[data_vgs[vg_list[1]]][vg_list[1]] else vg_list[1]
        free = vgs_info[data_vgs[vg]][vg]
        cp_list_data[vg] = free
        if free < 0.15:
            vg_15_list[vg] = free
        elif free > 0.7:
            vg_70_list[vg] = free

    (volumes, vgs) = rebalance_lib.get_cluster_info()
    print "volume list :{}\n".format(volumes)

    print "使用空间85%以上的复制组中的虚拟机文件统计情况:"
    for vg, vg_data in  vg_15_list.items():
        print "下面是vg:{} 的虚拟机文件使用情况".format(vg)
        print json.dumps(check_file(vg, volumes[0], inter_call='yes'), encoding='UTF-8', ensure_ascii=False)
	
    new_vgs = sorted(vg_70_list.items(), key=lambda x: x[0], reverse=True)
    print "\n\n70%以上的空闲盘复制组排序如下："
    print new_vgs



