#!/bin/bash

WORKDIR=""
LOCKFILE="/tmp/capture.lock"

function log_info()
{
    echo "$1" >> /sf/log/today/vs/tcpdump_network.sh.log
}

function do_ping()
{
    local ip="$1"
    local eth="$2"
    
    local time
    local log

    time=$(date +'%Y-%m-%d_%H_%M_%S')

    pinglog=${WORKDIR}/ping_${ip}.log
    tcpdumplog=${WORKDIR}/tcpdump_${ip}.cap
    
    pid=$(pgrep tcpdump)
    if [ ! -z "$pid" ]; then 
        log_info "tcpdump is exist, pid: $(ps axjf | grep tcpdump)"
        return 1
    fi
    
    log_info "begin check network: ${ip}, ${eth}"
    tcpdump -i $eth host $ip and -p icmp -nne -w "$tcpdumplog" > /dev/null 2>&1 &
    
    ping -w 700 -c 600 "$ip" &>  "$pinglog"

    # 停掉tcpdump
    pid=$(pgrep tcpdump)
    if [ -z "$pid" ]; then 
        log_info "tcpdump is not exist"
    else
        log_info "kill tcpdump: ${pid}"
        kill $pid
    fi
    
    # 如果有丢包就保留抓包结果
    if ! grep -q ', 0% packet loss' "$pinglog"; then
        mv "$pinglog" "${pinglog}.${time}"
        mv "$tcpdumplog" "${tcpdumplog}.${time}"
        
        log_info "packet loss, file: ${pinglog}.${time}, ${tcpdumplog}.${time}"
        exit 0
    fi
    
    rm -f "$pinglog"
    rm -f "$tcpdumplog"
    
    log_info "end check network: ${ip}, ${eth}"
}

function main()
{
    if [ $# -lt 1 ] || [ "$1" = "-h" ] || [ "$1" = "--help" ]; then
        echo "Usage: $0 <ip> <eth>"
        exit 0
    fi

    ip="$1"
    eth="$2"
    WORKDIR="$3"
    
    if [ -z "$eth" ]; then
        eth="sf_vs_bond0"
    fi

    # 检查锁文件是否存在
    if [ -e "$LOCKFILE" ]; then
        echo "已经有抓包脚本在运行中，退出..."
        exit 1
    fi

    # 创建锁文件
    touch "$LOCKFILE"

    # 确保在脚本结束时删除锁文件
    trap 'rm -f "$LOCKFILE"; killall -9 tcpdump;exit' INT TERM EXIT

    mkdir -p $WORKDIR
    
    while true; do
        do_ping "$ip" "$eth"
        sleep 1
    done

    # 删除锁文件
    rm -f "$LOCKFILE"
}


main "$@"
