#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 网络相关工具
"""

import subprocess32 as subprocess
import pylib.utils.utiltools as common

def do_clean_network(service_ip, host, nics):
    class Error(Exception):
        pass

    cmdline = ''
    for nic in nics:
        print ('清除主机:{},网口:{}'.format(host, nic))
        try:
            del_line = '/sf/vs/bin/vs_network.js -model del -host {}'.format(host)
            common.cli(del_line, True)
        except Error as e:
            print ("del host;{} network failed, reason: {}".format(host, e))

    try:
        cmdline = '/sf/bin/vtpsh set /nodes/{}/network/ifaces/{} -ip "" -netmask "" -role "" -restor 1'.format(host, nic)
        if common.get_vs_version() >= common.VS_VERSION_3_5:
            result = common.remote_vt_cli(service_ip, cmdline, True)
        else:
            result = common.remote_cli(service_ip, cmdline, True)
        for line in result:
            if line == '200 OK':
                print ('********************************************* [成功]')
    except Error as e:
        print 'cmdline：{}'.format(cmdline)
        print ("Failed to clean {}, reason: {}".format(nic, e))
        print ('********************************************* [失败]')

def check_exsit_protect_mode_by_vs350(ds_handle=None):
    """
    判断卷是否处于受保护模式
    """
    from libcommon.data_store.data_store import DataStore
    from libvs.volume.common import check_exist_hot_update_flag, check_update_flag_exists
    if not ds_handle:
        ds_handle = DataStore(store_type="mongo")
    if check_exist_hot_update_flag(ds_handle) or check_update_flag_exists("cold", ds_handle):
        return True
    else:
        return False

def is_exsit_protect_mode_vs():
    """
    判断卷是否处于受保护模式
    """
    try:
        return check_exsit_protect_mode_by_vs350()
    except Exception as e:
        print ( "检测存储是否处于升级中失败：失败原因： {}".format(e))
        return True
