#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 网络相关工具
"""
import os
import sys
import time
import subprocess
import psutil
import shutil
import json
import network_lib
import pylib.utils.utiltools as common

@common.only_support_3x
def if_clear(path='/cfs/vs/gfs_networking_mode.json'):
    """
    ## 网口清理
    """

    path = str(path)
    if network_lib.is_exsit_protect_mode_vs():
        print ('禁止清理：VS存储正在升级中')
        return -1

    if os.path.isfile(path):
        shutil.copy(path, '/sf/data/local/gfs_network_conf.bak')
    else:
        print ("{} 不存在！ 请指定正确的配置文件".format(path))
        return

    result = raw_input('\n此操作会清空存储网配置, 请谨慎操作！！ 如果确认操作，请输入: "-yes-i-really-mean-it-"\n')
    if result.lower() != '-yes-i-really-mean-it-':
        print("输入无效，操作未确认.")
        return

    with open(path, 'r') as file:
        content = file.read()
        network_conf = json.loads(content)

    for host_info in network_conf:
        if 'service_ip' not in host_info or 'host_name' not in host_info or 'nics' not in host_info:
            print ("请指定正确的集群网络配置!")
            return
        network_lib.do_clean_network(host_info['service_ip'],host_info['host_name'], host_info['nics'])


def capture(ip, eth, result='/sf/log/vs/vs_network_capture'):
    """
    ## 网口抓包
    """
    script_path = os.path.join(os.path.dirname(__file__), "vsts_network_capture.sh")
    subprocess.Popen([script_path, ip, eth, result], shell=False, stdout=sys.stdout, stderr=sys.stderr)

    time.sleep(2)
    pid = ""
    # 遍历所有进程
    for proc in psutil.process_iter():
        try:
            # 如果进程名匹配，则添加到列表中
            if len(proc.cmdline()) >=2 and 'vsts_network_capture.sh' in proc.cmdline()[1]:
                pid = proc.pid
                break
        except (psutil.NoSuchProcess, psutil.AccessDenied):
            print('抓包脚本未正常启动!!')
            exit(-1)

    print("抓包脚本正在执行, 进程号为： {}, 若有丢包会自动停止, 如果需要手动停止，请勿使用kill -9, 执行kill {}后等待即可,"
          " 抓包结果将保存在 {} 中, 脚本日志： /sf/log/today/vs/tcpdump_network.sh.log!".format(pid, pid, result))

def fix_iscsiip(confir, clustermode=True, interface=""):
    """
    ## EDS305R1~309升级309R1及以后版本VS接入复用管理网私网同网段导致升级失败问题
    """
    if confir != "confir":
        print("第一个参数必须为confir，防止误操作！")

    if clustermode:
        args = "-c -r"
    else:
        args = "r -i {}".format(interface)

    script_path = os.path.join(os.path.dirname(__file__), "fix_iscsi_ip.py")
    process = subprocess.Popen([script_path,args], shell=False, stdout=sys.stdout, stderr=sys.stderr)
    process.communicate()

    returncode = process.returncode

    if returncode == 0:
        print("Shell 脚本执行成功")
    else:
        print("Shell 脚本执行失败")


def cpu_bind(base_dir, ops, cpu):
    """
    ## 重新绑定cpu
    """
    def cpu_ops(base_dir, ops, cpu):
        items = os.listdir(base_dir)

        def cpu_ops_sub():
            for item in items:
                path = os.path.join(base_dir, item)
                if os.path.isdir(path):
                    cpu_ops(path, ops, cpu)

        if not 'add' == ops:
            cpu_ops_sub()

        path = os.path.join(base_dir, 'cpuset.cpus')
        if os.path.isfile(path):
            with open(path, 'r') as f:
                content = f.read().strip()
            ranges = []
            for seg in content.split(','):
                endpoints = seg.split('-')
                if len(endpoints) == 1:
                    ranges.append((int(endpoints[0]), int(endpoints[0]) + 1))
                else:
                    ranges.append((int(endpoints[0]), int(endpoints[1]) + 1))
            range_set = common.RangeSet(ranges)
            if 'add' == ops:
                if cpu not in range_set:
                    range_set.add(cpu)
            else:
                if cpu in range_set:
                    range_set.remove(cpu)

            if content != str(range_set):
                print("update %s: %s => %s" % (path, content, str(range_set)))
                with open(path, 'w') as f:
                    f.write(str(range_set))

        if 'add' == ops:
            cpu_ops_sub()

    cpu_ops(base_dir, ops, cpu)
