#!/bin/bash
# 
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#
# 功能: 清除指定文件的T文件
# 用法：vsts-clear-tfile.sh /sf/data/vs/gfs/rep2/images/cluster/win7.vm/vm-disk-1.qcow2 
# 适用: VS2.8及以下版本，不支持VS3.0版本
# 版本：Ver 1.0
#####################################################################
. /.PATH
. vs_logger.sh

CL='\033[0;34m'
NC='\033[0m'

IFS=$'\n'

function log()
{
        echo -e "${CL}$1${NC}"
        log_info "$1"
}

declare G_POSIX_FILE=/root/vsfire_recovery_FEC61AC2_tfile_posix.file
declare VOLNAME=$(gluster vol list)


function usage()
{
    echo -e "功能: 删除丢失dht-linto属性的T文件"
    echo -e "用法:"
    echo -e "    $0 ${CL}/sf/data/vs/gfs/rep2/images/cluster/win7.vm/vm-disk-1.qcow2${NC}"
}

function version_check()
{
    local ver
    ver=$(head -n1 /sf/vs/version )
    if [[ "${ver:0:3}" > "2.8" ]];then
        log "$0 is only used for vs2.8 or low version, current ver is $ver"
        exit 0
    fi 
}

function check_file()
{
    local file=$1
    
    #[ "${file:0:15}" == "/sf/data/vs_rep" ] &&  return 0
    [ "${file:0:19}" == "/sf/data/vs/gfs/rep" ] &&  return 0
    [ "${file:0:16}" == "/sf/data/vs/gfs/" ] &&  echo ${file} |grep -q ${VOLNAME} && return 0

    log "file: $file is wrong, please use path: /sf/data/vs/gfs/..." && return 1
}


function get_posix_file()
{
    local ret=0
    local file
    local filedir
    local filename
    local volpath
    local volpath_len
    local hostsinfo
    local file_path=$1

    volpath=$(cat /proc/mounts | grep "$VOLNAME" | grep gfs | awk '{print $2}' )
    if [ ! -d "$volpath" ]; then
        log "vol path is not exit: ${volpath}"
        exit 1
    fi
    
    volpath_len=${#volpath}
    file=${file_path:$volpath_len}
    if [ -z "$file" ]; then 
        log "failed to get file for $file_path"
    fi	
    
    filedir=$(dirname "$file")
    filename=$(basename "$file")
    
    
    hostsinfo=$(cat /sf/vs/glusterfs/etc/glusterd/vols/${VOLNAME}/info |grep -w host | awk -F= '{print $2}' | awk -F: '{print $1}' | sort | uniq)
    
    #clear file
    : > "$G_POSIX_FILE"
    
    for host in $hostsinfo; do 
        ssh root@$host "find /sf/data/vs/local/*/*/${filedir} -name ${filename} -exec echo $host {} \; 2>/dev/null" >> "$G_POSIX_FILE"
        if [ $? -ne 0 ]; then 
            log "ssh $host find /sf/data/vs/local/*/*/${filedir} -name ${filename} -exec echo $host {} \;, exec failed."
            ret=1
            break
        fi		
    done
    
    log "posix file in $G_POSIX_FILE"
    log "$(cat $G_POSIX_FILE)"
    
    return $ret
}


function delete_linkto_posix_file()
{
    local gfid
    local char1 
    local char2
    local file=$1
    local landfile
    local red='\033[0;31m'
    local blue='\033[0;34m'
    local nc='\033[0m'

    size=$(/sf/bin/busybox/stat -c '%s' $file)
    mode=0x$(/sf/bin/busybox/stat -c '%f' $file)

    if (( size == 0 && (mode & 0x200) )); then 
        gfid=$(/sf/vs/bin/getfattr --absolute-names -e hex  -n trusted.gfid $file | awk -F '0x' '/gfid/{print substr($2, 1, 8)}' 2>/dev/null)
        char1=$(echo $gfid | awk '{print substr($0, 1, 2)}')
        char2=$(echo $gfid | awk '{print substr($0, 3, 2)}')
        
        landfile="${file:0:94}/.glusterfs/$char1/$char2/$gfid*"
        
        echo -e "${red}start to delete linktofile${nc}: ${blue}$file${nc} ${blue}$landfile${nc}"
        rm $file $landfile

        return 0
    else
        return 1
    fi
}


function process_posix_file()
{
    local host
    local file

    for line in $(cat $G_POSIX_FILE);do 
        host=$(echo $line|awk -F' ' '{print $1}')
        file=$(echo $line|awk -F' ' '{print $2}')
        
        ssh root@$host "$(typeset -f); delete_linkto_posix_file $file"
        if [ $? -eq 1 ]; then 
            log "$host : $file is not T file, ignore it!"
        else
            log "$host : $file success to delete!"
        fi

    done
}


function main()
{
    if [[ $# -eq 0 || $# -gt 1 || "$1" == "-h" || "$1" == "--help" ]];then 
        usage
        exit 0
    fi
    
    version_check

    [ ! -e "$1" ] &&  log "file: $1, do not exist" # && exit 0
    
    # ! check_file "$1" && exit 0

    get_posix_file "$1"
    
    process_posix_file
    
}


main "$@"
