#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## T文件清理
"""

import os
import traceback
import pylib.utils.utiltools as common


def is_local_file_in_bricks(local_file, bricks):
    for host, bricks_info in bricks.items():
        for brick in bricks_info:
            if local_file.startswith(brick['path']):
                return True
    return False


def get_all_local_files(file_path, hosts, bricks):
    local_files = []
    local_tfiles = []
    cmdline = '/bin/ls -al /sf/data/vs/local/*/*/"{}"'.format(file_path)
    for host in hosts:
        try:
            result = common.remote_cli(host, cmdline, True)
            for line in result:
                if not line or len(line.split()) != 9:
                    continue

                # 硬链接数量为2
                nlinks = line.split()[1]
                if not nlinks.isdigit() or int(nlinks) != 2:
                    continue

                # 文件路径需要属于卷内
                local_file = line.split()[8]
                if not local_file.startswith('/sf/data/vs/local/') or not is_local_file_in_bricks(local_file, bricks):
                    continue

                if line.split()[0] == '---------T':
                    local_tfiles.append({'host': host, 'file': local_file})
                else:
                    local_files.append({'host': host, 'file': local_file})
        except common.CmdError as e:
            # 出现异常，忽略
            common.logger.warn('got except: {}'.format(str(e)))
            continue
    return local_files, local_tfiles


def remove_tfile_to_landfill(file_path, landfill_filename, local_tfiles):
    for local_tfile in local_tfiles:
        host = local_tfile['host']
        tfile_path = local_tfile['file']
        brick_path = tfile_path.replace(file_path, '')
        landfill_path = os.path.join(brick_path, '.glusterfs/landfill', landfill_filename)
        cmdline = '/bin/mv "{}" "{}"'.format(tfile_path, landfill_path)
        common.logger.info('try to exec host: {}, cmdline: {}'.format(host, cmdline))
        common.remote_cli(host, cmdline)


def clear_tfile_in_landfill(file_path, landfill_filename, local_tfiles):
    for local_tfile in local_tfiles:
        host = local_tfile['host']
        tfile_path = local_tfile['file']
        brick_path = tfile_path.replace(file_path, '')
        landfill_path = os.path.join(brick_path, '.glusterfs/landfill', landfill_filename)
        cmdline = '/sf/vs/bin/setfattr -n user.glusterfs.rubbish_allow_delete -v 1 "{}"'.format(landfill_path)
        common.logger.info('try to exec host: {}, cmdline: {}'.format(host, cmdline))
        common.remote_cli(host, cmdline)


def restore_tfile_from_landfill(file_path, landfill_filename, local_tfiles):
    for local_tfile in local_tfiles:
        host = local_tfile['host']
        tfile_path = local_tfile['file']
        brick_path = tfile_path.replace(file_path, '')
        landfill_path = os.path.join(brick_path, '.glusterfs/landfill', landfill_filename)
        cmdline = '/bin/mv "{}" "{}"'.format(landfill_path, tfile_path)
        common.logger.info('try to exec host: {}, cmdline: {}'.format(host, cmdline))
        common.remote_cli(host, cmdline)

        cmdline = '/sf/vs/bin/getfattr -d -m. -e hex "{}"'.format(tfile_path)
        result = common.remote_cli(host, cmdline, True)
        for line in result:
            if line and line.split('=')[0] == 'user.glusterfs.rubbish_allow_delete':
                cmdline = '/sf/vs/bin/setfattr -x user.glusterfs.rubbish_allow_delete "{}"'.format(tfile_path)
                common.logger.info('try to exec host: {}, cmdline: {}'.format(host, cmdline))
                common.remote_cli(host, cmdline)
                break


def tfile_clear_force(version, file_path, volume_name, hosts, replicate_num, bricks):
    if not isinstance(file_path, str) or not file_path.startswith('/'):
        # filename表示文件路径，一定是'/'开头
        common.logger.error('failed to supported, filename: {} is not path'.format(file_path))
        return -1

    # 去掉开头的'/'
    file_path = file_path[1:]

    local_files, local_tfiles = get_all_local_files(file_path, hosts, bricks)
    common.logger.info('get_all_local_files local_tfiles: {}, local_files: {}'.format(local_tfiles, local_files))

    # 副本数量至少大于等于2
    if not local_tfiles or len(local_files) < replicate_num:
        common.logger.error('failed to supported, cannot find tfile or file')
        return -1

    gfid = None
    for local_file in local_files:
        host = local_file['host']
        brick_path = local_file['file'].replace(file_path, '')
        gfid = common.vs_get_gfid_2x(host, brick_path, file_path)
        if gfid:
            break
    if not gfid:
        common.logger.error('failed to supported, cannot get file gfid')
        return -1

    landfill_filename = '{}_{}'.format(common.VSFIRE_MAGIC, gfid)
    common.logger.info('try to rename from entry: {} to landfill_entry: {}'.format(file_path, landfill_filename))
    try:
        # 将所有的T文件rename到landfill回收站
        remove_tfile_to_landfill(file_path, landfill_filename, local_tfiles)

        # 检查文件数据是否正确
        nfs_path = os.path.join(common.get_vs_mount_path(volume_name, version), file_path)
        readline = '检查文件:{} 是否正常, 检查完成之后，输入\'y\'继续操作，\'n\'退出'.format(nfs_path)
        common.check_terminal_input(readline)

        # 清空回收站
        clear_tfile_in_landfill(file_path, landfill_filename, local_tfiles)
        return 0
    except:
        common.logger.error('failed to fix tfile entry: {}, landfill_entry: {}, got except: {}'.
                            format(file_path, landfill_filename, traceback.format_exc()))
    # 尝试恢复下landfill下的文件
    restore_tfile_from_landfill(file_path, landfill_filename, local_tfiles)
    return -1


def tfile_clear(filename):
    version = common.get_vs_version()
    # 只支持vs2.6或者vs2.8
    if version >= common.VS_VERSION_3_0:
        common.logger.error('failed to supported, version: {}'.format(version))
        return -1

    volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
    if not volume_name:
        common.logger.error('failed to supported, volume_name: {}'.format(volume_name))
        return -1

    if not filename:
        # 如果输入参数为空，表示自动处理所有脑裂的T文件
        readline = '是否开始扫描所有脑裂文件，并自动清理T文件，输入\'y\'继续，\'n\'退出'
        common.check_terminal_input(readline)

        online_bricks = common.get_online_bricks(volume_name)
        if common.fault_point_result() or not online_bricks:
            # 至少有一个在线brick
            common.logger.error('failed to supported, cannot find online_bricks')
            return -1

        # 获取脑裂文件与虚拟机信息
        from modules.file_recovery.show_fault_files import get_fault_files_2x
        split_brain_files, split_brain_vms = get_fault_files_2x(version, volume_name)

        # 打印脑裂文件与虚拟机信息
        from modules.file_recovery.show_fault_files import print_fault_files_2x
        if split_brain_files:
            print_fault_files_2x(version, hosts, replicate, online_bricks, split_brain_files, [])
        else:
            print common.Colored().red('找不到脑裂文件')
            common.logger.error('failed to find split-brain files')
            return -1

        readline = '是否开始清理脑裂文件的T文件，输入\'y\'继续，\'n\'退出'
        common.check_terminal_input(readline)
        print common.Colored().cyan('日志输出路径：/sf/log/today/vs/scripts/vsts-clear-tfile.sh.log')

        script_path = os.path.join(os.path.dirname(__file__), 'vsts-clear-tfile.sh')
        for split_brain_file in split_brain_files:
            cmdline = '/bin/bash {} {}{}'.format(script_path,
                                                 common.get_vs_mount_path(volume_name, version), split_brain_file)
            common.logger.info('try to cmdline: {}'.format(cmdline))
            common.cli(cmdline)
            common.logger.info('success to cmdline: {}'.format(cmdline))
            tmp_files = ['/root/vsfire_recovery_FEC61AC2_tfile_posix.file']
            common.logger.info('success to cmdline: {} and rm files: {}'.format(cmdline, tmp_files))
            for tmp_file in tmp_files:
                if os.path.exists(tmp_file):
                    os.remove(tmp_file)
        return 0

    # 单独删除一个文件，强制删除
    return tfile_clear_force(version, filename, volume_name, hosts, replicate_num, bricks)


def _tfile_clear(filename):
    lock_file = common.get_vsfire_lock_file()
    with common.VsfireFlock(lock_file) as lock:
        ret = tfile_clear(filename)
        if ret:
            print common.Colored().red('执行失败')
        else:
            print common.Colored().cyan('执行成功')
        return ret
