#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 副本状态恢复
"""

import re
import sys
import pylib.utils.utiltools as common

s_force_choice_replica = common.VsfireConfig(common.s_vsfire_config_file).get_bool('replica_recovery', 'force_choice_replica')

def replica_has_bad_or_pending(xattr):
    for line in xattr:
        # 判断changelog是否有BAD
        if re.search(r"trusted.file_status", line):
            return True
        # 判断changelog是否有指控
        if re.search(r"vs_vol_rep\d-vclnt", line) and line.split('=')[1] != '0x000000000000000000000000':
            return True
    return False

def enable_data_replica_changelogs_2x(file_path, good_child_id, replicate_bricks, online_bricks):
    client_ids = []
    for brick in replicate_bricks:
        client_id = 'vs_vol_rep2-client-{}'.format(brick['id'] - 1)
        client_ids.append(client_id)

    common.enable_replica_changelogs_2x(file_path, good_child_id, client_ids, replicate_bricks, online_bricks)


def enable_meta_replica_changelogs_3x(file_path, good_child_id, replicate_bricks, online_bricks):
    meta_clients = ['vs_vol_rep\d-vclnt-0', 'vs_vol_rep\d-vclnt-1', 'vs_vol_rep\d-vclnt-2', 
                    'vs_vol_rep\d-vclnt-1000', 'vs_vol_rep\d-vclnt-1001']
    client_ids = []
    for index in range(len(replicate_bricks)):
        client_id = meta_clients[index]
        client_ids.append(client_id)
    common.enable_replica_changelogs_2x(file_path, good_child_id, client_ids, replicate_bricks, online_bricks, True)

def enable_data_replica_changelogs_3x(gfid, good_child_id, replicate_bricks, online_bricks):
    client_ids = []
    if len(replicate_bricks) == 2:
        client_ids = ['vs_vol_rep\d-vclnt-2', 'vs_vol_rep\d-vclnt-3']
        # 如果输入是gfid格式，转化成硬链接路径
        file_path = '.glusterfs/{}/{}/{}'.format(gfid[0:2], gfid[2:4], gfid)
        common.enable_replica_changelogs_2x(file_path, good_child_id, client_ids, replicate_bricks, online_bricks)
        return
    elif len(replicate_bricks) == 3:
        client_ids = ['vs_vol_rep\d-vclnt-3', 'vs_vol_rep\d-vclnt-4', 'vs_vol_rep\d-vclnt-5']
    else:
        client_ids = ['vs_vol_rep\d-vclnt-6', 'vs_vol_rep\d-vclnt-7', 'vs_vol_rep\d-vclnt-8', 
                      'vs_vol_rep\d-vclnt-9', 'vs_vol_rep\d-vclnt-10']

    common.enable_replica_changelogs_3x(gfid, good_child_id, client_ids, replicate_bricks, online_bricks)


def enable_data_replica(version, file_path, hosts, replicate, online_bricks):
    if version >= common.VS_VERSION_3_0:
        from modules.file_recovery.show_fault_files import get_file_replicate_3x
        recovery_replicate = get_file_replicate_3x(file_path, replicate, online_bricks)
    else:
        from modules.file_recovery.show_fault_files import get_file_replicate_2x
        recovery_replicate = get_file_replicate_2x(file_path, hosts, replicate)
    # 获取的数据复制组，只能是一个
    if not recovery_replicate or len(recovery_replicate) != 1:
        common.logger.error('failed to find data replicate: {}'.format(recovery_replicate))
        return -1
    
    gfid = ''
    if version >= common.VS_VERSION_3_0:
        gfid, replicate_bricks = next(iter(recovery_replicate.items()))
        # 如果输入是gfid格式，转化成硬链接路径
        file_path = '.glusterfs/{}/{}/{}'.format(gfid[0:2], gfid[2:4], gfid)
    else:
        rep_id, replicate_bricks = next(iter(recovery_replicate.items()))

    enable_child_id = -1
    need_chosen = False
    stats = []
    xattrs = []
    for index, brick in enumerate(replicate_bricks):
        if online_bricks.get(brick['path']) != 'y':
            xattrs.append(None)
            stats.append(None)
        else:
            try:
                if common.vs_has_efs(version, hosts) and not brick['arbiter']:
                    result = common.vs_getfattr_3x(brick['host'], brick['path'], gfid)
                else:
                    result = common.vs_getfattr_2x(brick['host'], brick['path'], file_path)
        
                if not need_chosen and replica_has_bad_or_pending(result.split('\n')):
                    need_chosen = True
                xattrs.append(result)

                # 两主机打印出mtime
                if common.vs_is_two_host(hosts):
                    cmdline = '/sf/bin/busybox/stat -c "%Y" {}/"{}"'.format(brick['path'], file_path)
                    stat_result = common.remote_cli(brick['host'], cmdline, False).split('\n')
                    stats.append(int(stat_result[0]))
            except common.CmdError as e:
                if not 'No such file or directory' in str(e):
                    raise
                else:
                    xattrs.append(None)
                    stats.append(None)


    # 复制组，没有指控就不需要选源了
    if not s_force_choice_replica and not need_chosen:
        return 0
    
    print common.Colored().cyan('数据复制组, 处理文件: {}'.format(file_path))
    for index, brick in enumerate(replicate_bricks):
        if online_bricks.get(brick['path']) != 'y':
            print common.Colored().cyan('id: {}, brick_id: {}, host: {}, path: {}'.format(index, brick['id'], brick['host'], brick['path']))
            print common.Colored().red('无法获取指控信息，副本可能已经离线\n')
        else:
            print common.Colored().cyan('id: {}, brick_id: {}, host: {}, path: {}'.format(index, brick['id'], brick['host'], brick['path']))
            if stats and len(stats) > index and stats[index]:
                print common.Colored().cyan('mtime: {}'.format(stats[index]))
            if xattrs and len(xattrs) > index and xattrs[index]:
                print common.Colored().cyan('{}'.format(xattrs[index]))
            else:
                print common.Colored().red('无法获取指控信息，副本可能不存在\n')

    while True:
        print common.Colored().fuchsia('请输入需要启用的副本id, 输入id范围为: {}, 输入\'n\'表示不启用'.format(range(len(replicate_bricks) / 2 + 1)))
        id_input = sys.stdin.readline().strip('\n')
        if id_input.isdigit() and int(id_input) < len(replicate_bricks) / 2 + 1:
            enable_child_id = int(id_input)
            break
        elif id_input.strip().lower() == 'n':
            return 0
        else:
            print common.Colored().red('输入错误，请重新输入')
    
    if enable_child_id != -1:
        if version >= common.VS_VERSION_3_0:
            enable_data_replica_changelogs_3x(gfid, enable_child_id, replicate_bricks, online_bricks)
        else:
            enable_data_replica_changelogs_2x(file_path, enable_child_id, replicate_bricks, online_bricks)
    return 0


def enable_meta_replica(file_path, replicate, online_bricks):
    from modules.file_recovery.show_fault_files import get_file_replicate_3x
    recovery_replicate = get_file_replicate_3x('', replicate, online_bricks)
    if not recovery_replicate or len(recovery_replicate) != 1:
        common.logger.error('failed to find meta replicate: {}'.format(recovery_replicate))
        return -1
    
    # 元数据，只存在一个复制组
    root_gfid, replicate_bricks = next(iter(recovery_replicate.items()))
    enable_child_id = -1
    need_chosen = False
    xattrs = []
    for index, brick in enumerate(replicate_bricks):
        if online_bricks.get(brick['path']) != 'y':
            xattrs.append(None)
        else:
            try:
                result = common.vs_getfattr_2x(brick['host'], brick['path'], file_path)
                if not need_chosen and replica_has_bad_or_pending(result.split('\n')):
                    need_chosen = True
                xattrs.append(result)
            except common.CmdError as e:
                if not 'No such file or directory' in str(e):
                    raise
                else:
                    xattrs.append(None)

    # 复制组，没有指控就不需要选源了
    if not need_chosen:
        return 0
    
    print common.Colored().cyan('元数据复制组, 处理文件: {}'.format(file_path))
    for index, brick in enumerate(replicate_bricks):
        if online_bricks.get(brick['path']) != 'y':
            print common.Colored().cyan('id: {}, brick_id: {}, host: {}, path: {}'.format(index, brick['id'], brick['host'], brick['path']))
            print common.Colored().red('无法获取指控信息，副本可能已经离线\n')
        else:
            print common.Colored().cyan('id: {}, brick_id: {}, host: {}, path: {}'.format(index, brick['id'], brick['host'], brick['path']))
            if xattrs and len(xattrs) > index and xattrs[index]:
                print common.Colored().cyan('{}'.format(xattrs[index]))
            else:
                print common.Colored().red('无法获取指控信息，副本可能不存在\n')

    while True:
        print common.Colored().fuchsia('请输入需要启用的副本id, 输入id范围为: {}, 输入\'n\'表示不启用'.format(range(len(replicate_bricks))))
        id_input = sys.stdin.readline().strip('\n')
        if id_input.isdigit() and int(id_input) < len(replicate_bricks):
            enable_child_id = int(id_input)
            break
        elif id_input.strip().lower() == 'n':
            return 0
        else:
            print common.Colored().red('输入错误，请重新输入')
    
    if enable_child_id != -1:
        enable_meta_replica_changelogs_3x(file_path, enable_child_id, replicate_bricks, online_bricks)
    return 0


def enable_file_replica(version, file_path, hosts, replicate, online_bricks):
    file_path = file_path[1:] # 去掉开头的'/'
    common.logger.info('try to enable replica status, file: {}'.format(file_path))

    # 3.x版本，先处理左子树
    if version >= common.VS_VERSION_3_0:
        ret = enable_meta_replica(file_path, replicate, online_bricks)
        if ret:
            common.logger.error('failed to enable meta replica status')
            return ret
    
    # 处理右子树
    ret = enable_data_replica(version, file_path, hosts, replicate, online_bricks)
    if ret:
        common.logger.error('failed to enable data replica status')
    return ret


def enable_replica(filename):
    version = common.get_vs_version()
    if not common.is_vs_version_valid(version):
        return -1

    volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
    if not volume_name:
        common.logger.error('failed to supported, volume_name: {}'.format(volume_name))
        return -1

    online_bricks = common.get_online_bricks(volume_name)
    if common.fault_point_result() or not online_bricks:
        # 至少有一个在线brick
        common.logger.error('failed to supported, cannot find online_bricks')
        return -1
    
    result = 0
    if not filename:
        # 如果输入参数为空，表示自动处理所有脑裂虚拟机
        readline = '是否开始扫描所有脑裂文件，输入\'y\'继续，\'n\'退出'
        common.check_terminal_input(readline)

        if version >= common.VS_VERSION_3_0:
            # 3x版本获取脑裂分片
            from modules.file_recovery.show_fault_files import get_split_brain_shards_3x
            split_brain_shards = get_split_brain_shards_3x()
            if not split_brain_shards:
                common.logger.error('failed to find split_brain_shards')
                return 0
            
            # 打印脑裂分片
            shard_msg_print = ''
            for index, err_shard in enumerate(split_brain_shards):
                shard_msg_print += err_shard
                shard_msg_print += ' '
                if (index + 1) % 4 == 0 and index != len(split_brain_shards) - 1:
                    shard_msg_print += '\n'
            if shard_msg_print:
                print common.Colored().red('\n找到脑裂的分片:')
                print common.Colored().cyan('{}'.format(shard_msg_print))

            readline = '\n是否开始处理所有脑裂分片, 输入\'y\'继续，\'n\'退出'
            common.check_terminal_input(readline)
            
            for shard_gfid in split_brain_shards:
                if not common.check_str_is_gfid(shard_gfid):
                    continue
                # 如果输入是gfid格式，转化成硬链接路径
                filename = '/.glusterfs/{}/{}/{}'.format(shard_gfid[0:2], shard_gfid[2:4], shard_gfid)
                if enable_file_replica(version, filename, hosts, replicate, online_bricks):
                    print common.Colored().red('文件: {}, 设置副本状态失败'.format(filename))
                    result = -1
        else:
            # 2x版本获取脑裂文件
            split_brain_files = common.get_split_brain_files(volume_name, version)
            if not split_brain_files:
                common.logger.error('failed to find split_brain_files')
                return 0
            
            # 打印脑裂文件
            from modules.file_recovery.show_fault_files import print_fault_files_2x
            print_fault_files_2x(version, hosts, replicate, online_bricks, split_brain_files, {})

            readline = '\n是否开始处理所有脑裂文件, 输入\'y\'继续，\'n\'退出'
            common.check_terminal_input(readline)
            
            for filename in split_brain_files:
                if enable_file_replica(version, filename, hosts, replicate, online_bricks):
                    print common.Colored().red('文件: {}, 设置副本状态失败'.format(filename))
                    result = -1
        
    elif isinstance(filename, str):
        if common.check_str_is_gfid(filename):
            # 如果输入是gfid格式，转化成硬链接路径
            filename = '/.glusterfs/{}/{}/{}'.format(filename[0:2], filename[2:4], filename)
            return enable_file_replica(version, filename, hosts, replicate, online_bricks)
        elif filename.startswith('/'):
            # 输入文件路径，如果是VS3.x版本，只处理首分片
            return enable_file_replica(version, filename, hosts, replicate, online_bricks)
        else:
            common.logger.error('failed to supported, filename: {} is invalid'.format(filename))
            result = -1
    else:
        common.logger.error('failed to supported, filename: {} is invalid'.format(filename))
        result = -1
    return result


def _enable_replica(filename):
    lock_file = common.get_vsfire_lock_file()
    with common.VsfireFlock(lock_file) as lock:
        ret = enable_replica(filename)
        if ret:
            print common.Colored().red('执行失败')
        else:
            print common.Colored().cyan('执行成功')
        return ret
