#!/bin/bash
# 从lv中恢复文件

function recover_file()
{
    local path="$1"
    local gfid="$2"
    local seek=0
    local size=0

    IFS=$'\n'

    for shard in $(lvs --unit m --nosuffix | grep $gfid | sort -t '.' -k 2 -b -n); do
        vg=$(echo $shard | awk '{print $2}')
        lv=$(echo $shard | awk '{print $1}')
        size=$(echo $shard | awk '{printf "%d", $NF}')

        # TODO check size

        echo dd if=/dev/$vg/$lv of="$path"/$gfid.qcow2 bs=1M seek=$seek iflag=direct oflag=direct conv=notrunc
        dd if=/dev/$vg/$lv of="$path"/$gfid.qcow2 bs=1M seek=$seek iflag=direct oflag=direct conv=notrunc

        if [ $? -ne 0 ]; then
            echo "Recover file $gfid to $path failed"
            exit 1
        fi

        seek=$((seek + size))
    done
}


if [ "$1" = "-h" ] || [ "$1" = "--help" ] || [ $# -ne 2 ] ; then
    echo "Usage: $0 <path> <gfid>  (eg: $0 /sf/data/vs_rep2  abcdef)"
    exit 1
fi

recover_file "$1" "$2"
