#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 文件恢复工具
"""
from modules.file_recovery.tfile_clear import _tfile_clear
from modules.file_recovery.file_recovery import _file_recovery
from modules.file_recovery.copy_and_replace import _copy_and_replace
from modules.file_recovery.show_fault_files import _show_fault_files
from modules.file_recovery.replica_recovery import _enable_replica
from modules.file_recovery.vg_segment_defrag import _vg_defrag
from modules.file_recovery.snapshot_meta import _snapshot_meta_dump


def file_recovery(filename=''):
    """
    文件恢复（适用于文件脑裂，数据副本双点等文件出现数据损坏场景）(支持vs2.6/vs2.8/vs3.x)

    基本原理：遍历文件内每个分片，拷贝副本数据，最后将数据拼接成完整文件数据
    针对2.x以及3.x两主机，自动备份次优副本源，再修改源文件启用最优副本源
    针对3.x三主机以上，手动选择副本源进行恢复，不会修改源文件
    输入：
        filename: 如果为空，表示自动查找脑裂文件及对应虚拟机，再依次对每个脑裂虚拟机执行恢复处理
                  如果为虚拟机的vmid（1523476242006），表示修复指定虚拟机目录下的所有文件（3.x两主机版本不支持cfg文件处理）
                  如果为文件路径（/images/cluster/test.vm/vm-disk-1.qcow2），表示修复指定的文件
    """
    _file_recovery(filename)


def tfile_clear(filename=''):
    """
    T文件清理（适用于由于T文件脑裂导致文件无法访问的场景）(支持vs2.6/vs2.8)

    基本原理：遍历所有在线副本，删除T文件
    输入：
        filename: 如果为空，表示自动清理所有脑裂文件的T文件（限定T文件大小为0）
                  如果为文件路径（/images/cluster/test.vm/vm-disk-1.qcow2），
                        表示清理指定的文件的T文件（强行清理，不限制T文件大小，删除之后等待10分钟，文件彻底删除）
    """
    _tfile_clear(filename)


def copy_and_replace(filename):
    """
    文件拷贝并自替换（适用于文件状态不对，重新拷贝一份文件并替换自己）(支持vs2.6/vs2.8/vs3.x)

    基本原理：重新拷贝一份文件并替换自己
    输入：
        filename: 文件路径（/images/cluster/test.vm/vm-disk-1.qcow2)，表示拷贝指定的文件
    """
    _copy_and_replace(filename)


def show_fault_files():
    """
    集群异常后，显示异常的分片，文件，与虚拟机(支持vs2.6/vs2.8/vs3.x)

    """
    _show_fault_files()


def enable_replica(filename=''):
    """
    启用副本状态（适用于副本状态异常，无法正常访问的场景）(支持vs2.6/vs2.8/vs3.x)

    基本原理：修改副本状态为正常（针对所在在线副本，去除对启用恢复的指控）
    输入：
        filename: 如果为空, 表示遍历所有的脑裂分片/文件, 并执行副本状态设置
                  如果filename为文件路径 (/images/cluster/test.vm/vm-disk-1.qcow2), 表示设置文件的副本状态
                  如果filename为文件gfid (db450973-5e63-4b4c-941b-64fee56de65f), 表示设置分片的副本状态

    """
    _enable_replica(filename)

def vg_defrag(vgname=''):
    """
    VG碎片整理, 适用于VG由于segment太多,导致lv访问慢的场景(支持vs2.6/vs2.8/vs3.x两主机)
    
    基本原理: 找到VG中segment最多的LV执行拷贝, 再删除原LV, 最后重命名拷贝的LV
    输入：
        vgname: 如果为空, 表示自动统计当前主机所有VG的segment, 当大于阈值后，依次执行碎片整理 
                卷组名称(GXVZ8w-teVK-Nqg1-steG-2gX1-Mljk-bbb4W1), 表示执行碎片整理的VG
    """
    _vg_defrag(vgname)

def snapshot_meta_dump(filename):
    """
    打印快照元数据信息并设置元数据中的base gfid
    
    vs_rpc_tool --cmd snapshot_enable --switch on # 放通快照隐藏文件显示
    
    输入：
        filename: 快照元数据文件路径 (/vs/snapshot/c6/c6f89255-c9a0-4dc0-b045-55eee9938e68/meta/meta.raw)

    """
    _snapshot_meta_dump(filename)
