#!/bin/bash
#处理由于磁盘的scsi id改变，页面显示磁盘离线的问题，适用于VS3.0以下的版本

logfile=/sf/log/today/vs/fix_disk_scsiid.sh.log
diskpath=/sf/cfg/vs/disk
partpath=/sf/cfg/vs/partition
diskbackup=/sf/data/local/disk_backup


version=$(cat /sf/vs/version | head -n 1)
if [[ "${version:0:3}" < "2.8" ]]; then 
    diskpath=/cfs/vs/disk
    partpath=/cfs/vs/partition
fi;

if [ ! -f $diskbackup/backup_flag ]; then
    cp -R $diskpath $diskbackup
    cp -R $partpath $diskbackup
    touch $diskbackup/backup_flag
fi


IFS=$'\n'; 
for line in $(vs_vginfo.sh | grep dev); 
do 
    dev=$(echo $line | awk '{print $1}');
    vg=$(echo $line | awk '{print $2}'); 
    scsiid=$(/lib/udev/scsi_id --whitelisted --replace-whitespace --device=$dev); 
    host=$(hostname); 
    
    if [ -z "$scsiid" ]; then
        echo "scsi id is null: $dev" >> "$logfile"
        continue
    fi
    
    
    #新的scsi id
    new_disk=${host#*-}_${scsiid};
 
    diskfile=$(grep $vg ${diskpath} -rn -m1 | awk -F: '{print $1}');
    if [ -z "${diskfile}" ]; then
        echo "Can not find disk file of vg: $vg" >> "$logfile"
        continue
    fi
    
    # 磁盘配置中旧的scsi id
    old_disk=$(/sf/vs/bin/vs_json_rw.js $diskfile disk);
    if [ "$new_disk" == "$old_disk" ]; then
       continue;
    fi
    
    echo ------------------begin >> "$logfile"; 
    echo "disk file: $diskfile" >> "$logfile"; 
    echo "old disk: $old_disk" >> "$logfile"; 
    echo "new disk: $new_disk" >> "$logfile"; 
    echo "vg: $vg, dev: $dev" >> "$logfile";

    for partfile in $(grep $vg ${partpath} -rn | awk -F: '{print $1}'); 
    do 
        echo /sf/vs/bin/vs_json_rw.js $partfile disk \"$new_disk\" >> "$logfile"; 
        /sf/vs/bin/vs_json_rw.js $partfile disk \"$new_disk\"; 
    done; 
    
    echo /sf/vs/bin/vs_json_rw.js $diskfile disk \"$new_disk\" >> "$logfile"; 
    /sf/vs/bin/vs_json_rw.js $diskfile disk \"$new_disk\"; 
    /sf/vs/bin/vs_json_rw.js $diskfile fault \"NONE\"; 
    /sf/vs/bin/vs_json_rw.js $diskfile status \"NORMAL\"; 
    /sf/vs/bin/vs_json_rw.js $diskfile dev \"${dev:0:-1}\"; 
    
    if [[ "${version:0:3}" < "2.8" ]]; then 
        echo rm -f /sf/cfg/vs/disk/${old_disk}.json >> "$logfile"
        rm -f /sf/cfg/vs/disk/${old_disk}.json
    fi;
    
    echo mv $diskfile ${diskpath}/${new_disk}.json -f >> "$logfile"; 
    mv $diskfile ${diskpath}/${new_disk}.json -f; 
 
    echo ------------------end >> "$logfile"; 
done;
