#!/sf/vs/bin/python
# -*-coding:utf-8-*-

import os
import sys
import argparse
import json
import subprocess
from libcommon import config
import zkapi.zk_op as zk
from functools import partial
from  pylib.utils.utiltools  import DISK_CONF, BACK_PATH, DISK_PARTITION, _get_host_name_id, get_vs_version

json_dumps = partial(json.dumps, ensure_ascii=False, sort_keys=True, indent=4)
json_loads = lambda d: json.loads(d)


def back_file(file, path):
    try:
        print('backup file: cp {} {}'.format(file, path))
        cmd = 'cp {} {}'.format(file, path)
        subprocess.check_output(cmd, shell=True)
    except Exception as e:
        print ('----------!!!error :: exec {} failed!!!----------'.format(cmd))
        raise


def move_file(old, new):
    try:
        print('move file: mv {} {}'.format(old, new))
        cmd = 'mv {} {}'.format(old, new)
        subprocess.check_output(cmd, shell=True)
    except Exception as e:
        print ('----------!!!error :: exec {} failed!!!----------'.format(cmd))
        raise


def change_disk_conf(scsi_id, new_scsi_id):
    host_id = _get_host_name_id()
    disk_path = DISK_CONF + host_id + '_' + scsi_id + '.json'
    print('\n\n1. start change disk conf:{}'.format(disk_path))
    if not os.path.exists(BACK_PATH):
        os.mkdir(BACK_PATH)
    back_file(disk_path, BACK_PATH)
    content = config.json_load(disk_path)
    content['dev'] = ''
    content['disk'] = host_id + '_' + new_scsi_id
    content['status'] = 'UNNORMAL'
    config.save(disk_path, json.dumps(content, sort_keys=True, indent=4, separators=(',', ': ')))
    disk_group = content['disk_group_id']

    back_path = DISK_CONF + host_id + '_' + new_scsi_id + '.json'
    move_file(disk_path, back_path)

    part_num = 1
    for part in content['part_array']:
        part_file = DISK_PARTITION + 'host-' + host_id + '_' + part['part_uuid'] + '_part_' + str(part_num) + '.json'
        print('\n\n2. start change parttion conf:{}'.format(part_file))
        back_file(part_file, BACK_PATH)
        part_content = config.json_load(part_file)
        part_content['disk'] = host_id + '_' + new_scsi_id
        config.save(part_file, json_dumps(part_content))
        part_num += 1
    return disk_group

def change_zk_disk_conf(disk_group, scsi_id, new_scsi_id):
    version = get_vs_version()
    if version >= "3.3":
        from libcommon.data_store.data_store import DataStore
        zk_handle = DataStore()
    elif version >= "3.0":
        zk_handle = zk.zk_op()

    host_id = _get_host_name_id()
    group_str = '/nodes/' + 'host-' + host_id + '/diskgroups/' + str(disk_group)
    print('\n\n3. start change zk disk group conf:{}'.format(group_str))
    content = zk_handle.read(group_str)
    content_js = json_loads(content)
    print('old conf is:{}'.format(content_js))
    disk_scsiid = host_id + '_' + scsi_id
    new_disk_scsiid = host_id + '_' + new_scsi_id
    content_js['disks'].remove(disk_scsiid)
    content_js['disks'].append(new_disk_scsiid)
    print('new conf is:{}'.format(content_js))
    content = json_dumps(content_js)
    zk_handle.write(group_str, content.encode("utf-8"))

    disk_size = '/nodes/' + 'host-' + host_id + '/disksize/' + disk_scsiid + '.json'
    print('\n\n4. start rm zk disk size conf:{}'.format(disk_size))
    content = zk_handle.read(disk_size)
    content_js = json_loads(content)
    print('disk size content is:{}'.format(content_js))

    if version >= "3.3":
        zk_handle.rm(disk_size)
    elif version >= "3.0":
        zk_handle.unlink(disk_size)

    new_disk_size = '/nodes/' + 'host-' + host_id + '/disksize/' + new_disk_scsiid + '.json'
    print('\n\n5. start create zk disk size conf:{}'.format(new_disk_size))
    content = json_dumps(content_js)

    if version >= "3.3":
        zk_handle.write(new_disk_size, content.encode("utf-8"))
    elif version >= "3.0":
        zk_handle.create(new_disk_size, content.encode("utf-8"))

