#!/sf/vs/bin/python
# -*- coding:utf-8 -*-
"""
## 磁盘自替换工具

### 场景说明
- 某些场景之下，磁盘里面的数据损坏了，但是磁盘是好的，需要把磁盘重新利用起来。
插拔磁盘之后，由于同一个磁盘的scsi id不变，导致无法识别到新的磁盘，也就无法通过自身来替换数据损坏的磁盘。
  针对该问题，本工具提供一种磁盘自替换的功能.

### 命令说明

```shell
1. 检查vsfire.py工具是否可执行权限，若没有则添加 chmod +x vsfire.py

2. 获取磁盘scsi id,在/sf/cfg/vs/disk/目录下，文件名就是hostname_scsiid

3. 执行./vsfire.py disk disk_self_replace scsi_id

4. 命令执行成功后，在web页面点击磁盘替换，就会出现磁盘，按页面指引一步一步走
```
"""
import time
import json
import os
from functools import partial
from libcommon import config
from  pylib.utils.utiltools  import DISK_CONF, BACK_PATH, DISK_PARTITION, _get_host_name_id

DISK_CFG_NAME_SUFFIX = '_replace'

json_dumps = partial(json.dumps, ensure_ascii=False, sort_keys=True, indent=4)


def _is_process_exist(process_name):
    cmd = 'ps aux |grep {} |grep -v supervise | grep -v grep'.format(process_name)
    if process_name in os.popen(cmd).readline():
        return True
    return False


def _is_compound_volume():
    content = config.json_load('/sf/cfg/vs/volume.json')
    if 'volume_type' in content and content['volume_type'] == 'compound':
        return True
    return False


def _db_unlink(db_handle, path):
    if _is_process_exist('mongod') is True:
        db_handle.rm(path)
    else:
        db_handle.unlink(path)


def _db_create(db_handle, path, content):
    if _is_process_exist('mongod') is True:
        db_handle.write(path, content.encode("utf-8"))
    else:
        db_handle.create(path, content.encode("utf-8"))


# 注意返回值为disk_group_id
def _modify_local_dick_conf(scis_id):
    host_id = _get_host_name_id()
    disk_path = DISK_CONF + host_id + '_' + scis_id + '.json'

    if not os.path.exists(BACK_PATH):
        os.mkdir(BACK_PATH)

    os.system('cp -f {} {}'.format(disk_path, BACK_PATH))
    print("copy {} to {}".format(disk_path, BACK_PATH))

    content = config.json_load(disk_path)
    content['dev'] = ''
    content['disk'] = content['disk'] + DISK_CFG_NAME_SUFFIX
    content['status'] = 'UNNORMAL'
    config.save(disk_path, json.dumps(content, sort_keys=True, indent=4, separators=(',', ': ')))
    new_path = DISK_CONF + host_id + '_' + scis_id + DISK_CFG_NAME_SUFFIX + '.json'

    os.system('mv -f {} {}'.format(disk_path, new_path))
    print("rename {} to {}".format(disk_path, new_path))

    part_num = 1
    for part in content['part_array']:
        part_file = DISK_PARTITION + 'host-' + host_id + '_' + \
                    part['part_uuid'] + '_part_' + str(part_num) + '.json'

        os.system('cp -f {} {}'.format(part_file, BACK_PATH))
        print("copy {} to {}".format(part_file, BACK_PATH))

        part_content = config.json_load(part_file)
        part_content['disk'] = part_content['disk'] + DISK_CFG_NAME_SUFFIX
        config.save(part_file, json_dumps(part_content))
        part_num += 1
        print("modify file:{}, content:{}".format(part_file, part_content))

    disk_group = 0
    if 'disk_group_id' in content:
        disk_group = content['disk_group_id']
    return disk_group


def _modify_compound_disk_conf(db_handle, disk_scisid):
    vol_list = db_handle.lsdir('/volumes/')
    if 'vs_vol_pool.json' in vol_list:
        vol_list.remove('vs_vol_pool.json')
        print("remove /volumes/vs_vol_pool.json from db")

    for vol_name in vol_list:
        diskmap_path = '/volumes/' + vol_name + '/vs_vol_diskmap.json'
        if db_handle.exists(diskmap_path):
            content = db_handle.read(diskmap_path)
            content_js = json.loads(content)
            for host_group_info in content_js['hosts']:
                for disk_group_info in host_group_info['disk_groups']:
                    if disk_scisid in disk_group_info['disk']:
                        disk_group_info['disk'].remove(disk_scisid)
                        disk_group_info['disk'].append(disk_scisid + DISK_CFG_NAME_SUFFIX)
                        content = json_dumps(content_js)
                        print("write path: {}, content: {}".format(diskmap_path, content))
                        db_handle.write(diskmap_path, content.encode("utf-8"))
                        return True
    return False


def _modify_db_disk_conf(scis_id, disk_group):
    if _is_process_exist('mongod') is True:
        print("modify mg disk config")
        from libcommon.data_store.data_store import DataStore
        db_handle = DataStore(store_type="mongo")
    else:
        print("modify zk disk config")
        import zkapi.zk_op as zk
        db_handle = zk.zk_op()

    host_id = _get_host_name_id()
    disk_scisid = host_id + '_' + scis_id
    disk_group_path = '/nodes/host-' + host_id + '/diskgroups/' + str(disk_group)
    disk_size_path = '/nodes/host-' + host_id + '/disksize/' + disk_scisid + '.json'
    new_disk_size_path = '/nodes/host-' + host_id + '/disksize/' + disk_scisid + DISK_CFG_NAME_SUFFIX + '.json'

    # 修改磁盘组
    if db_handle.exists(disk_group_path):
        content = db_handle.read(disk_group_path)
        content_js = json.loads(content)
        if disk_scisid in content_js['disks']:
            content_js['disks'].remove(disk_scisid)
            content_js['disks'].append(disk_scisid + DISK_CFG_NAME_SUFFIX)
        content = json_dumps(content_js)
        db_handle.write(disk_group_path, content.encode("utf-8"))
        print("db_path:{}, content:{}".format(disk_group_path, content))

    # 修改磁盘大小
    if db_handle.exists(disk_size_path):
        content = db_handle.read(disk_size_path)
        content_js = json.loads(content)
        _db_unlink(db_handle, disk_size_path)
        content = json_dumps(content_js)
        _db_create(db_handle, new_disk_size_path, content)
        print("db_path:{}, content:{}".format(new_disk_size_path, content))

    # 复合卷需要修改其他配置
    if _is_compound_volume():
        _modify_compound_disk_conf(db_handle, disk_scisid)



