#!/bin/bash
# vst_plug_nvme.sh plugout 3473790d30c6_SNVMe_INTEL_SSDPE2KX0PHLJ137302EH4P0VGN

. vs_common_disk_interface.sh

if [ $# -lt 2 ];then
    echo "please input op and dev"
    exit 1
fi

op=$1
if [ "$op" != "plugin" ] && [ "$op" != "plugout" ];then
    echo "please input plugin or plugout,op is $op"
    exit 1
fi

disk=$2
disk=${disk#*_}
disk_name=''
for nvme in $(/sf/vs/bin/nvme list | grep 'dev/nvme' | awk '{print $1}')
do
    if [ "$disk" == $(vs_get_disk_unique_id $nvme)  ];then
        disk_name=$(basename $nvme)
        break
    fi
done
if [ "$op" == 'plugout' ] && [ -z "$disk_name" ];then
    echo "please input correct nvme disk_id, disk is $disk"
    exit 1
fi

if [ "$op" == 'plugout' ];then
    path=$(find /sys/devices -name "$disk_name" | grep pci)
    path=${path%/nvme/*}
    echo "$path" > /tmp/vs/tmp_plug_nvme_"$disk"
    echo 1 > "$path"/remove #拔盘
fi

if [ "$op" == 'plugin' ];then
    if [ -f /tmp/vs/tmp_plug_nvme_"$disk" ];then
        path=$(cat /tmp/vs/tmp_plug_nvme_"$disk")
        path=${path%/*}
        rm -f /tmp/vs/tmp_plug_nvme_"$disk"
        echo 1 > "$path"/rescan
    else
        echo "please plugout $disk_name before."
    fi
fi

