#!/sf/vs/bin/python
# -*- coding:utf-8 -*-
"""
## 磁盘配置修复以及自替换

### 场景说明
- 某些场景之下，磁盘里面的数据损坏了，但是磁盘是好的，需要把磁盘重新利用起来。
插拔磁盘之后，由于同一个磁盘的scsi id不变，导致无法识别到新的磁盘，也就无法通过自身来替换数据损坏的磁盘。
  针对该问题，本工具提供一种磁盘自替换的功能.

### 命令说明

```shell
1. 检查vsfire.py工具是否可执行权限，若没有则添加 chmod +x vsfire.py

2. 获取磁盘scsi id,在/sf/cfg/vs/disk/目录下，文件名就是hostname_scsiid

3. 执行./vsfire.py disk disk_self_replace scsi_id

4. 命令执行成功后，在web页面点击磁盘替换，就会出现磁盘，按页面指引一步一步走
```
"""
import os
import time
import subprocess
from self_replace import _modify_local_dick_conf, _modify_db_disk_conf
import pylib.utils.utiltools as common
import uuid_fix3x
from libvs.utils.common import LOCALHOST
from libcommon.libconf import LocalDiskConf as _LocalDiskConf

_SCSI_ID_MINLEN = 8
_NEVER_RECOVERD_DISK_PATH = '/sf/cfg/vs/never_recoverd_disks.json'


def self_replace(scsi_id):
    """磁盘自替换"""
    scsi_id = str(scsi_id)
    if len(scsi_id) < _SCSI_ID_MINLEN:
        print("Please input legal disk scsi id!")
        return

    if common._is_localhost_exist_device(scsi_id) is False:
        print("This device is not exist, Please check host!")
        return

    if common._get_disk_status(scsi_id) == "NORMAL":
        print("disk status is NORMAL, not need to replace!")
        return

    common._print_disk_info(scsi_id)

    result = raw_input("请输入yes确认:")
    if result != "yes":
        return

    try:
        disk_group_id = _modify_local_dick_conf(scsi_id)

        _modify_db_disk_conf(scsi_id, disk_group_id)

        cmd = '/sf/vs/bin/disk_scan.sh 2>/dev/null'
        print("exec cmd:{}".format(cmd))
        os.popen(cmd)

        print("Sucess! Please go to web to complete self-replace!")

    except Exception as ex:
        print ("disk self replace failed! {}".format(ex))


def diskuuid_repair():
    """修复磁盘配置，用于raid卡替换后，磁盘UUID改变，导致硬盘出现新旧两份配置的场景"""
    if common.is_vs2x():
        # 2.x版本
        shell_script = "modules/disk/uuidfix_2x.sh"
        process = subprocess.Popen(shell_script, shell=True, stdout=sys.stdout, stderr=sys.stderr)
        process.communicate()

        returncode = process.returncode

        if returncode == 0:
            print("Shell 脚本执行成功")
        else:
            print("Shell 脚本执行失败")
        return

    # 3.x版本
    old_scsiid = str(raw_input("输入硬盘的旧scsi id:"))
    new_scsiid = str(raw_input("输入硬盘的新scsi id:"))

    if len(old_scsiid) < _SCSI_ID_MINLEN  or len(new_scsiid) < _SCSI_ID_MINLEN:
        print("Please input legal old scsi id and new scsi id!")
        return

    if common._is_localhost_exist_device(old_scsiid) is False or common._is_localhost_exist_device(new_scsiid) is False:
        print("This device is not exist, Please check host!")
        return

    try:
        print('--------args: {} -------------'.format(old_scsiid))
        disk_group = uuid_fix3x.change_disk_conf(old_scsiid, new_scsiid)
        uuid_fix3x.change_zk_disk_conf(disk_group, old_scsiid, new_scsiid)
        print ('\n\n-------- success -------------')

    except Exception as ex:
        print("disk uuid:{} fix failed: {}".format(old_scsiid, ex))


def nvme_plug(dev, op):
    """NVME热插拔"""
    shell_script = "modules/disk/nvme_plug.sh"
    process = subprocess.Popen([shell_script, op, dev], shell=False, stdout=sys.stdout, stderr=sys.stderr)
    process.communicate()

    returncode = process.returncode
    if returncode == 0:
        print("Shell 脚本执行成功")
    else:
        print("Shell 脚本执行失败")
    return


@common.only_support_3x
def slowdisk_recover():
    """恢复被隔离的卡慢盘"""

    result = raw_input('\n此操作会解除被隔离的卡慢盘,有影响业务的风险，请谨慎操作！！ 如果确认操作，请输入: "-yes-i-really-mean-it-"\n')
    if result.lower() != '-yes-i-really-mean-it-':
        print("输入无效，操作未确认.")
        return

    if common.get_vs_version() >= common.VS_VERSION_3_3:
        from libcommon.mongo_file import Host
    else:
        from libcommon.zk_file import Host
    flag = 0
    disks = Host(LOCALHOST).list_disks(lambda d: d['storage_type'] in ['STORAGE_DATA'])
    for disk in disks:

        disk_id = disk['disk']
        disk_config = _LocalDiskConf(disk_id)

        if "never_recoverd" in disk['disk_warning_expand']:
            sub_health_status = disk_config.content['disk_warning_expand']
            sub_health_status.pop('never_recoverd')
            flag = 1

        if 'temporary_remove' in disk and disk['temporary_remove'] == 1:
            disk_config.content['temporary_remove'] = 0
            flag = 1
            
    if flag:
        disk_config.save()
        print 'clear never_recoverd for {}, {}'.format(disk['dev'], disk['disk'])

        print 'clean /sf/cfg/vs/never_recoverd_disks.json'
        if os.path.exists(_NEVER_RECOVERD_DISK_PATH):
            os.remove(_NEVER_RECOVERD_DISK_PATH)
        common.cli('echo "" > {}'.format(_NEVER_RECOVERD_DISK_PATH))
        print 'plug disk ...'
        hot_plug_cmd = "/sf/vs/bin/vs_hotplug.sh"
        common.cli(hot_plug_cmd)
        time.sleep(10)
        scan_cmd = "/sf/vs/bin/disk_scan.sh"
        common.cli(scan_cmd)
    else:
        print 'No slow disk ...'


@common.only_support_3x
def disk_rebuild(brick_no):
    """brick重建"""

    from vs_rpc.vs_rpc_api import VsRpcApi
    vra = VsRpcApi()

    res = vra.vs_list_file(brick_no)
    if res['ret'] < 0:
        print("failed to list file, brick_no: {}".format(brick_no))
        return 1

    report_msg = []
    file_count = len(res['files'])
    print ("brick {} has {} file".format(brick_no, file_count))

    if common.get_vs_version() >= common.VS_VERSION_3_3:
        from vs_dts.dtsc.interface import DtsIface
        for file_index in xrange(file_count):
            gfid = res['files'][file_index]['gfid']
            report_msg.append(gfid)
            print("report brick {} gfid {}".format(brick_no, gfid))
        DtsIface.report_shard_rebuild(brick_no, report_msg)
    else:
        from vs_dts.utils.rpc_call import RemoteCall
        for shard_info in res['files']:
            rebuild_info = {
                'gfid': shard_info['gfid'],
                'path': shard_info['path'],
                'task_type': 'rebuild',
                'version': shard_info['route_version'],
                'route_info': shard_info['route_info'],
                'rebuild_source': brick_no
            }
            report_msg.append(rebuild_info)

        shard_list = report_msg
        task_type = "rebuild"
        vol_master = common.get_vol_master()
        mod = RemoteCall.connect(vol_master, 'dts_sched')
        mod.interface.ScheCenterIf.custom_add_shard_tasks(brick_no, shard_list, task_type)

