#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## 坏道修复工具
"""
from modules.bad_blocks.bad_blocks_lv import _lv_data_repair
from modules.bad_blocks.bad_blocks_efs import _efs_data_repair
from modules.bad_blocks.bad_blocks_tier import _tier_data_repair
from modules.bad_blocks.bad_blocks_tier_meta import _tier_metadata_repair

# def lv_metadata(dev):
#     """
#     2.x版本，lv的元数据区域坏道修复工具 [未实现]
#
#     输入:
#         lv_dev: 出现坏道的lv块设备
#     """
#     return -1


def lv_data(lv_dev=''):
    """
    2.x版本, lv的数据区域坏道修复工具
    3.x版本, 两主机, lv的数据区域坏道修复工具

    输入:
        如果输入为空, 表示自动从最新的日志中获取存在坏道的LV块设备
        如果输入为 lv_dev: 出现坏道的lv块设备
            格式要求： /dev/2ikbL0-q3cp-jjpx-Ppt4-OtMG-0JNj-IJFTDK/2ikbL0-q3cp-jjpx-Ppt4-OtMG-0JNj-IJFTDK_0e9a68171a084641a3c576376ace545e.0
    """
    _lv_data_repair(lv_dev)


# def efs_metadata():
#     """
#     3.x版本, efs元数据区域修复
#     使用efs_repair工具
#
#     输入:
#         filename: 如果为空，表示自动修复所有脑裂的文件
#                   如果为虚拟机的vmid（1523476242006），表示修复指定虚拟机目录下的所有文件
#     """
#     return -1


def efs_data(gfid=''):
    """
    3.x版本, 三主机以上, efs数据区域修复

    输入:
        如果输入为空, 表示自动从最新的日志中获取存在坏道的分片gfid
        如果输入为 gfid: 表示修复分片的GFID
            格式要求： 73a30a8a-ef8b-4c67-a76a-b747cedb27bc
    """
    _efs_data_repair(gfid)


def tier_metadata(ssd_uuid):
    """
    tier元数据区域修复(支持vs2.6/vs2.8/vs3.x版本, 分层v1/v2/v3版本)

    输入：
        ssd_uuid 分层UUID, 格式要求: by5aIi-B33n-8Uj2-T456-JWvZ-hPjA-RjHV6M
    """
    _tier_metadata_repair(ssd_uuid)


def tier_data(gfid):
    """
    tier数据区域修复(支持vs2.6/vs2.8/vs3.x版本, 分层v1/v2/v3版本)

    输入:
        如果输入为 gfid: 表示修复分片的GFID
    """
    _tier_data_repair(gfid)
