#!/sf/vs/bin/python
# -*- coding:utf-8 -*-

"""
## efs坏道修复工具
"""
import os
import re
import sys
import time
import json
import socket
import traceback
import pylib.utils.utiltools as common

repair_scheme_write_efs = 1
repair_scheme_write_hdd = 2

def try_bad_blocks_repair(gfid, src_brick, dst_brick, offset_block, block_size, volume_name, repair_scheme, is_forced):
    src_efs_mount_path = '/mnt/{}_{}/{}'.format(src_brick['path'].split('/')[5], common.VSFIRE_MAGIC, gfid)
    dst_efs_mount_path = '/mnt/{}_{}/{}'.format(dst_brick['path'].split('/')[5], common.VSFIRE_MAGIC, gfid)

    if repair_scheme == repair_scheme_write_hdd:
        import pylib.rpcservice as rpcservice
        hdd_dev, hdd_offset = rpcservice.badblock_scan_change_offset(volume_name, dst_brick['id'], gfid,
                                                                     offset_block*block_size, block_size)
        if not hdd_dev or not hdd_offset or hdd_offset % block_size != 0:
            error_msg = 'failed to get hdd_dev: {} or hdd_offset: {}'.format(hdd_dev, hdd_offset)
            common.logger.error(error_msg)
            return -1

        # 确认目的端是坏道才允许修复，不然跳过
        if not common.check_dev_has_badblock(dst_brick['host'], hdd_dev, hdd_offset, block_size):
            common.logger.error('failed to check badblock, dev: {}, offset: {}'.format(hdd_dev, hdd_offset))
            print common.Colored().red('gfid：{}, 块设备: {}, 偏移: {} 无法确认该区间是真坏道, 请重试修复该坏道区间'.format(gfid, hdd_dev, hdd_offset))
            return -1
        common.calc_dev_block_md5(dst_brick['host'], hdd_dev, hdd_offset, block_size)

        cmdline = '/usr/bin/ssh root@{} \"/bin/dd if={} bs={} count=1 skip={} iflag=direct conv=notrunc\" | ' \
                  '/usr/bin/ssh root@{} \"/bin/dd of={} bs={} count=1 seek={} oflag=direct conv=notrunc\"'. \
            format(common.get_ssh_host(src_brick['host']), src_efs_mount_path, block_size, offset_block,
                   common.get_ssh_host(dst_brick['host']), hdd_dev, block_size, hdd_offset/block_size)
    else:
        # 确认目的端是坏道才允许修复，不然跳过
        if not common.check_dev_has_badblock(dst_brick['host'], dst_efs_mount_path, offset_block*block_size, block_size):
            common.logger.error('failed to check badblock, dev: {}, offset: {}'.
                                format(dst_efs_mount_path, offset_block*block_size))
            print common.Colored().red('gfid: {}, 块设备: {}, 偏移: {} 无法确认该区间是真坏道, 请重试修复该坏道区间'.
                                       format(gfid, dst_efs_mount_path, offset_block*block_size))
            return -1
        common.calc_dev_block_md5(dst_brick['host'], dst_efs_mount_path, offset_block*block_size, block_size)

        cmdline = '/usr/bin/ssh root@{} \"/bin/dd if={} bs={} count=1 skip={} iflag=direct conv=notrunc\" | ' \
                  '/usr/bin/ssh root@{} \"/bin/dd of={} bs={} count=1 seek={} oflag=direct conv=notrunc\"'. \
            format(common.get_ssh_host(src_brick['host']), src_efs_mount_path, block_size, offset_block,
                   common.get_ssh_host(dst_brick['host']), dst_efs_mount_path, block_size, offset_block)

    # 判断是否执行坏道修复
    if not is_forced:
        readline = '是否执行坏道修复，修复命令:{}，输入\'y\'继续, \'n\'退出'.format(cmdline)
        common.check_terminal_input(readline)

    common.logger.info('try to cmdline: {}'.format(cmdline))
    common.cli(cmdline, False)
    if repair_scheme == repair_scheme_write_hdd:
        common.calc_dev_block_md5(dst_brick['host'], hdd_dev, hdd_offset, block_size)
    else:
        common.calc_dev_block_md5(dst_brick['host'], dst_efs_mount_path, offset_block*block_size, block_size)
    return 0

def check_and_get_badblock_brick_id(replicate_bricks):
    brick_ids = []
    host_brick_ids = []
    for brick in replicate_bricks:
        if not brick['arbiter']:
            brick_ids.append(brick['id'])
            host_brick_ids.append('{}:{}'.format(brick['host'], brick['id']))
    
    if not brick_ids:
        common.logger.error('failed to get brick_ids')
        return -1

    readline = '当前分片分布的brick编号列表: {}, 请输入坏道所在路由编号数字'.format(host_brick_ids)
    while True:
        print common.Colored().fuchsia('{}'.format(readline))
        step = sys.stdin.readline().strip('\n')
        if step.isdigit() and int(step) in brick_ids:
            return int(step)
        else:
            print common.Colored().red('输入字符错误，请重新输入')

# 确认坏道修复方案
def check_repair_scheme(dst_brick):
    repair_scheme = repair_scheme_write_efs
    while True:
        readline = '请联系研发协助，选择修复方案:\n' \
                    '方案1: 修复目的分片(注意: 需要停止目的brick进程, 可能影响其它虚拟机业务);\n' \
                    '方案2: 修复目的磁盘(注意: 需要在坏道所在主机: {} 执行，不影响其它虚拟机业务，优先选择本方案)，输入\'1\'或者\'2\''.format(dst_brick['host'])
        print common.Colored().fuchsia('{}'.format(readline))
        step = sys.stdin.readline().strip('\n')
        if step.isdigit():
            if int(step) == repair_scheme_write_efs:
                repair_scheme = repair_scheme_write_efs
                break
            elif int(step) == repair_scheme_write_hdd:
                repair_scheme = repair_scheme_write_hdd
                break
        else:
            print common.Colored().red('输入字符错误，请重新输入')
    return repair_scheme

def check_impact_other_vms(volume_name, dst_brick):
    # 提示受影响的虚拟机列表
    # 获取排除坏道副本检查，其它副本无法选出源的分片
    import pylib.rpcservice as rpcservice
    err_shards_path = rpcservice.route_check_brick(dst_brick['id'], 'weak')
    if err_shards_path:
        err_files = []
        all_shards = rpcservice.route_list_all_shards(volume_name)
        for shard_path in err_shards_path:
            base_path = rpcservice.file_to_base_file_path(shard_path, all_shards)
            err_files.append(base_path)
        if err_files:
            err_files = list(set(err_files))  # 去重处理
            vms_info = common.files_path_to_vms_name(err_files)
            file_msg_print = ''
            for index, err_file in enumerate(err_files):
                file_msg_print += err_file
                file_msg_print += ' '
                if (index + 1) % 1 == 0:
                    file_msg_print += '\n'
            vm_msg_print = ''
            for index, (vm_id, vm_name) in enumerate(vms_info.items()):
                vm_msg_print += vm_name
                vm_msg_print += ' '
                if (index + 1) % 1 == 0:
                    vm_msg_print += '\n'

            if not vm_msg_print:
                readline = '继续执行坏道修复，将影响以下文件:\n{}\n'.format(file_msg_print)
            else:
                readline = '继续执行坏道修复，将影响以下文件:\n{}\n相关虚拟机:\n{}\n'.format(file_msg_print, vm_msg_print)
            print common.Colored().cyan('{}'.format(readline))
            readline = '请确认是否继续，输入\'y\'继续，\'n\'退出'
            common.check_terminal_input(readline)

def prepare_dst_brick(dst_brick):
    common.stop_brick_process(dst_brick['host'], dst_brick['path'])
    common.mount_efs_path(dst_brick, False, False)
    time.sleep(3)  # 由于挂载点是刚挂载的，需要等待3秒才可以访问

def post_dst_brick(dst_brick):
    common.umount_efs_path(dst_brick)
    common.continue_brick_process(dst_brick['host'], dst_brick['path'])

def efs_data_repair(gfid, brick_id, volume_name, has_arbiter, replicate, online_bricks, hosts):
    common.logger.info('try to _efs_data_repair, gfid: {}'.format(gfid))
    bad_blocks_route_id = -1
    bad_blocks_offsets = []
    bad_block_size = 4096  # 默认坏道块大小为4096
    src_brick = {}  # 坏道修复的源副本
    dst_brick = {}  # 坏道修复的目标副本（也就是存在坏道的副本）

    # 获取文件的复制组
    import modules.bad_blocks.bad_blocks_tier as bad_blocks_tier
    replicate_bricks = bad_blocks_tier.get_file_replicate_bricks(common.VS_VERSION_3_0, gfid, hosts, replicate, online_bricks)
    if not replicate_bricks:
        common.logger.error('failed to get replicate_bricks')
        return -1
    
    # 提示业务影响
    bad_blocks_tier.check_vm_is_stopped(common.VS_VERSION_3_0, gfid, volume_name, hosts)

    if brick_id != -1:
        bad_blocks_route_id = brick_id
    else:
        bad_blocks_route_id = check_and_get_badblock_brick_id(replicate_bricks)
    
    # 获取坏道修复的源与目的brick
    src_brick, dst_brick = bad_blocks_tier.get_src_and_dst_brick(replicate_bricks, None, bad_blocks_route_id)
    if not src_brick or not dst_brick:
        common.logger.error('failed to get src_brick: {} or dst_brick: {}'.format(src_brick, dst_brick))
        return -1
    
    # 选择坏道修复方案
    localhost = socket.gethostname()
    repair_scheme = check_repair_scheme(dst_brick)
    if repair_scheme == repair_scheme_write_efs:
        # 选择EFS挂载修复，需要重启目的brick，可能影响其它虚拟机
        check_impact_other_vms(volume_name, dst_brick)
    else:
        # 选择磁盘修复，需要保证在目的brick所在主机执行
        if localhost != dst_brick['host']:
            print common.Colored().red('当前不在坏道所在主机，请切换到主机: {} 执行'.format(dst_brick['host']))
            return -1
    
    bad_blocks_offsets_path = '/root/{}_badblocks.txt'.format(common.vsfire_recovery_dir)  # 默认坏道扫描文件
    try:
        # 以只读模式挂载目的efs挂载点，用于扫描坏道
        common.mount_efs_path(dst_brick)

        bad_file_mount_efs_path = '/mnt/{}_{}/{}'.format(dst_brick['path'].split('/')[5], common.VSFIRE_MAGIC, gfid)
        if dst_brick['host'] == localhost:
            cmdline = '/sbin/badblocks -b {} -o /root/{}_badblocks.txt {}'.format(bad_block_size, common.vsfire_recovery_dir, bad_file_mount_efs_path)
        else:
            cmdline = '/sbin/badblocks -b {} -o /root/{}_badblocks.txt {}; /usr/bin/scp -r root@{}:{} root@{}:{};'. \
                format(bad_block_size, common.vsfire_recovery_dir, bad_file_mount_efs_path,
                    dst_brick['host'], bad_blocks_offsets_path, localhost, bad_blocks_offsets_path)
        bad_blocks_offsets_path, bad_blocks_offsets = bad_blocks_tier.try_scan_or_get_badblock_offset(dst_brick['host'], cmdline, bad_blocks_offsets_path, bad_block_size)
        # 卸载目的efs挂载点
        common.umount_efs_path(dst_brick)
    except:
        common.logger.error('failed to bad_blocks_efs: {}, got except:{}'.format(gfid, traceback.format_exc()))
        # 卸载目的efs挂载点
        common.umount_efs_path(dst_brick)

    if not bad_blocks_offsets:
        common.logger.error('failed to get bad_blocks_offsets in file: {}'.format(bad_blocks_offsets_path))
        return -1

    result = 0
    has_force_clean_wcache = True
    try:
        # 坏道修复前，准备源brick
        has_force_clean_wcache = bad_blocks_tier.prepare_src_brick(volume_name, gfid, True, src_brick)

        # 坏道修复前，准备目的brick
        if repair_scheme == repair_scheme_write_efs:
            prepare_dst_brick(dst_brick)

        # 开始执行坏道修复
        is_forced = False  # 默认第1次执行需要手工确认，主要是自动计算的偏移地址需要确认
        for offset in bad_blocks_offsets:
            if try_bad_blocks_repair(gfid, src_brick, dst_brick, offset, bad_block_size,
                                  volume_name, repair_scheme, is_forced):
                result = -1
            
            # 成功过一次，说明后面的坏道修复比较安全，不需要再重复确认了
            if not result:
                is_forced = True

        # 坏道修复后，尝试删除临时文件
        cmdline = '/bin/rm -f {}'.format(bad_blocks_offsets_path)
        common.logger.info('try to host: {}, cmdline: {}'.format(localhost, cmdline))
        common.remote_cli(localhost, cmdline)
        common.logger.info('try to host: {}, cmdline: {}'.format(dst_brick['host'], cmdline))
        common.remote_cli(dst_brick['host'], cmdline)

        # 坏道修复后，回退目的brick
        if repair_scheme == repair_scheme_write_efs:
            post_dst_brick(dst_brick)
        # 坏道修复后，回退源brick
        bad_blocks_tier.post_src_brick(has_force_clean_wcache, volume_name, True, src_brick)
        return result
    except:
        common.logger.error('failed to bad_blocks_efs: {}, got except:{}'.format(gfid, traceback.format_exc()))

    # 异常场景，尝试删除临时文件
    cmdline = '/bin/rm -f {}'.format(bad_blocks_offsets_path)
    common.logger.info('try to host: {}, cmdline: {}'.format(localhost, cmdline))
    common.remote_cli(localhost, cmdline)
    common.logger.info('try to host: {}, cmdline: {}'.format(dst_brick['host'], cmdline))
    common.remote_cli(dst_brick['host'], cmdline)

    # 坏道修复后，回退目的brick
    if repair_scheme == repair_scheme_write_efs:
        post_dst_brick(dst_brick)
    # 坏道修复后，回退源brick
    bad_blocks_tier.post_src_brick(has_force_clean_wcache, volume_name, True, src_brick)
    return -1


# 将坏道扫描的日志路径转化成对应的brick_id
def get_brick_id_from_bricks(badblock_log_path, bricks):
    for host, bricks_info in bricks.items():
        for brick in bricks_info:
            if brick['path'].split('/')[-1] in badblock_log_path and brick['path'].split('/')[-2] in badblock_log_path:
                return brick['id']
    return None


def get_badblocks_from_log(hosts, bricks):
    badblocks_gfids = []
    badblocks_gfids_raw = []  # 保存直接从日志中查找到的数据
    cmdline = 'for file in $(/usr/bin/find /sf/log/today/vs/log/glusterfs/bricks -type f -name "*.log"); ' \
              'do /usr/bin/tail -c 1M "$file" | /bin/grep "efs_preadv_handler].*op_errno: 5$" | ' \
              '/usr/bin/awk -F: -v fname="$file" "{ print fname, \$5 }" | /usr/bin/sort -u; done'
    for host in hosts:
        try:
            result = common.remote_cli(host, cmdline, True)
            for line in result:
                # line格式 '/sf/log/today/vs/log/glusterfs/bricks/glusterfsd_sf-data-vs-local-
                # 9uQbGC-wKjt-izNQ-0y4g-E2HE-vxDX-0b9z9x-b8656368-4204-4b5f-abdb-3db532c47e84.log
                # 9ceb623d-612a-4023-ab2f-c57449aa5ea0(33)'
                if len(line.split()) == 2 and \
                        line.split()[0].startswith('/sf/log/today/vs/log/glusterfs/bricks/'
                                                   'glusterfsd_sf-data-vs-local-') and \
                        re.match(r"\w{8}-\w{4}-\w{4}-\w{4}-\w{12}", line.split()[1]):
                    badblocks_gfids_raw.append(line)
        except common.CmdError:
            # 有主机获取日志错误，直接忽略
            common.logger.warn('failed to host: {}, cmdline: {}'.format(host, cmdline))

    # 转化成格式 [6, '9ceb623d-612a-4023-ab2f-c57449aa5ea0']
    for badblocks_gfid in badblocks_gfids_raw:
        brick_id = get_brick_id_from_bricks(badblocks_gfid.split()[0], bricks)
        if brick_id:
            badblocks_gfids.append([brick_id, badblocks_gfid.split()[1][0:36]])
    return badblocks_gfids


def efs_data_repair_start(gfid):
    version = common.get_vs_version()
    # 只支持3.0以上版本
    if not common.is_vs_version_valid(version) or version < common.VS_VERSION_3_0:
        common.logger.error('failed to supported, version: {}'.format(version))
        return -1

    volume_name, hosts, replicate_num, has_arbiter, bricks, replicate = common.get_vs_cluster_info()
    if common.fault_point_result() or not volume_name:
        common.logger.error('failed to supported, cannot find volume name')
        return -1

    online_bricks = common.get_online_bricks(volume_name)
    if common.fault_point_result() or not online_bricks:
        common.logger.error('failed to supported, cannot find online_bricks')
        return -1

    # 判断环境是否有EFS
    if not common.vs_has_efs(version, hosts):
        common.logger.error('failed to supported, numbers of hosts is {}'.format(len(hosts)))
        return -1

    result = 0
    if not gfid:
        # 如果输入参数为空，表示自动从日志中获取坏道块设备
        readline = '是否搜索存储日志，获取存在坏道的分片，输入\'y\'继续，\'n\'退出'
        common.check_terminal_input(readline)
        badblocks_gfids = get_badblocks_from_log(hosts, bricks)
        if not badblocks_gfids:
            print common.Colored().red('找不到存在坏道的块设备')
            return -1

        badblocks_vms = {}
        import pylib.rpcservice as rpcservice
        for badblocks_gfid in badblocks_gfids:
            gfid = badblocks_gfid[1]
            file_path = rpcservice.gfid_to_base_file_path(gfid, None)
            vms_info = common.files_path_to_vms_name([file_path])
            if not vms_info:
                vm_name = None
            else:
                vmid, vm_name = next(iter(vms_info.items()))

            if not badblocks_vms.get(vm_name):
                badblocks_vms[vm_name] = [badblocks_gfid]
            else:
                vm_gfids = badblocks_vms.get(vm_name)
                vm_gfids.append(badblocks_gfid)
                badblocks_vms[vm_name] = vm_gfids

        for vm_name, badblocks_gfids in badblocks_vms.items():
            if vm_name:
                print common.Colored().cyan('找到虚拟机:{} 存在坏道的分片列表: {}'.format(vm_name, badblocks_gfids))
            else:
                print common.Colored().cyan('找到非虚拟机，存在坏道的分片列表: {}'.format(badblocks_gfids))

        readline = '是否开始修复找到的分片上的坏道，输入\'y\'继续，\'n\'退出'
        common.check_terminal_input(readline)

        for vm_name, badblocks_gfids in badblocks_vms.items():
            for badblocks_gfid in badblocks_gfids:
                try:
                    brick_id = badblocks_gfid[0]
                    gfid = badblocks_gfid[1]
                    if efs_data_repair(gfid, brick_id, volume_name, has_arbiter, replicate, online_bricks, hosts):
                        result = -1
                except common.CmdError as e:
                    if 'Manual check cancellation' in str(e):
                        result = -1
                        continue
                    else:
                        raise
        return result

    if not re.match(r"\w{8}-\w{4}-\w{4}-\w{4}-\w{12}", gfid):
        common.logger.error('failed to supported, gfid: {}'.format(gfid))
        return -1

    return efs_data_repair(gfid, -1, volume_name, has_arbiter, replicate, online_bricks, hosts)


def _efs_data_repair(gfid):
    lock_file = common.get_vsfire_lock_file()
    with common.VsfireFlock(lock_file) as lock:
        ret = efs_data_repair_start(gfid)
        if ret:
            print common.Colored().red('执行失败')
        else:
            print common.Colored().cyan('执行成功')
        return ret
